const axios = require('axios');

const BASE_URL = 'http://localhost:5500';

async function testVillageCodeFix() {
    console.log('🧪 [TEST] Testing Village Code Fix...\n');
    
    // Test with the specific village code that was failing
    const testVillageCode = '281109012';
    
    try {
        console.log(`📝 [TEST] Testing village code: ${testVillageCode}`);
        console.log(`📝 [TEST] Expected: Should find schools now with numeric conversion`);
        
        const response = await axios.get(`${BASE_URL}/api/schools/schools/${testVillageCode}`);
        
        console.log(`✅ [TEST] API Response:`, JSON.stringify(response.data, null, 2));
        
        if (response.data.success && response.data.data.totalSchools > 0) {
            console.log(`🎉 [TEST] SUCCESS! Found ${response.data.data.totalSchools} schools:`);
            response.data.data.schools.forEach((school, index) => {
                console.log(`  ${index + 1}. School Name: ${school.school_name}`);
                console.log(`     School Code: ${school.udise_school_code}`);
                console.log('');
            });
        } else {
            console.log(`⚠️ [TEST] Still no schools found for village code: ${testVillageCode}`);
            console.log(`📊 [TEST] This might mean the village code doesn't exist in the database`);
        }
        
    } catch (error) {
        console.error('❌ [TEST] Test failed:', error.response?.data || error.message);
    }
    
    // Test with a few more village codes to verify the fix works generally
    const testCodes = ['10101001', '10101002', '350103001'];
    
    for (const code of testCodes) {
        try {
            console.log(`\n📝 [TEST] Testing village code: ${code}`);
            const response = await axios.get(`${BASE_URL}/api/schools/schools/${code}`);
            
            if (response.data.success && response.data.data.totalSchools > 0) {
                console.log(`✅ [TEST] Found ${response.data.data.totalSchools} schools for ${code}`);
            } else {
                console.log(`⚠️ [TEST] No schools found for ${code}`);
            }
        } catch (error) {
            console.log(`❌ [TEST] Error testing ${code}:`, error.response?.data?.message || error.message);
        }
    }
    
    console.log('\n🎉 [TEST] Village code fix test completed!');
}

// Run the test
testVillageCodeFix().catch(console.error);
