const axios = require('axios');

const testServer = async () => {
    const BASE_URL = 'http://localhost:5000';
    
    console.log('🔍 Testing server endpoints...');
    
    try {
        // Test root endpoint
        console.log('\n1. Testing root endpoint...');
        const rootResponse = await axios.get(`${BASE_URL}/`);
        console.log('✅ Root endpoint:', rootResponse.data);
        
        // Test health endpoint
        console.log('\n2. Testing health endpoint...');
        const healthResponse = await axios.get(`${BASE_URL}/health`);
        console.log('✅ Health endpoint:', healthResponse.data);
        
        // Test 404 endpoint
        console.log('\n3. Testing 404 endpoint...');
        try {
            await axios.get(`${BASE_URL}/nonexistent`);
        } catch (error) {
            if (error.response?.status === 404) {
                console.log('✅ 404 handling:', error.response.data);
            } else {
                console.log('❌ Unexpected error:', error.response?.data);
            }
        }
        
        // Test API endpoints
        console.log('\n4. Testing API endpoints...');
        
        // Test users endpoint
        try {
            const usersResponse = await axios.get(`${BASE_URL}/api/users/all`);
            console.log('✅ Users endpoint:', usersResponse.data);
        } catch (error) {
            console.log('❌ Users endpoint error:', error.response?.status, error.response?.data);
        }
        
        // Test auth endpoint
        try {
            const authResponse = await axios.post(`${BASE_URL}/api/auth/login`, {
                mobile: '+1234567890',
                password: 'password123'
            });
            console.log('✅ Auth endpoint:', authResponse.data);
        } catch (error) {
            console.log('❌ Auth endpoint error:', error.response?.status, error.response?.data);
        }
        
    } catch (error) {
        console.error('❌ Server test failed:', error.message);
        if (error.code === 'ECONNREFUSED') {
            console.log('💡 Server is not running. Please start it with: npm run dev');
        }
    }
};

testServer();
