const axios = require('axios');

const BASE_URL = 'http://localhost:5500';

async function testSchoolsSimple() {
    console.log('🧪 [TEST] Testing Schools API with Simple Response...\n');
    
    try {
        // First, let's get some village codes to test with
        console.log('📝 [TEST] Step 1: Getting states...');
        const statesResponse = await axios.get(`${BASE_URL}/api/schools/states`);
        console.log(`✅ [TEST] Found ${statesResponse.data.data.totalStates} states`);
        
        if (statesResponse.data.data.states.length > 0) {
            const firstState = statesResponse.data.data.states[0];
            console.log(`📝 [TEST] Using state: ${firstState.state_name} (${firstState.state_code})`);
            
            // Get districts
            console.log('📝 [TEST] Step 2: Getting districts...');
            const districtsResponse = await axios.get(`${BASE_URL}/api/schools/districts/${firstState.state_code}`);
            console.log(`✅ [TEST] Found ${districtsResponse.data.data.totalDistricts} districts`);
            
            if (districtsResponse.data.data.districts.length > 0) {
                const firstDistrict = districtsResponse.data.data.districts[0];
                console.log(`📝 [TEST] Using district: ${firstDistrict.district_name} (${firstDistrict.district_code})`);
                
                // Get villages
                console.log('📝 [TEST] Step 3: Getting villages...');
                const villagesResponse = await axios.get(`${BASE_URL}/api/schools/villages/${firstDistrict.district_code}`);
                console.log(`✅ [TEST] Found ${villagesResponse.data.data.totalVillages} villages`);
                
                if (villagesResponse.data.data.villages.length > 0) {
                    const firstVillage = villagesResponse.data.data.villages[0];
                    console.log(`📝 [TEST] Using village: ${firstVillage.village_name} (${firstVillage.udise_village_code})`);
                    
                    // Get schools - this is the main test
                    console.log('📝 [TEST] Step 4: Getting schools...');
                    const schoolsResponse = await axios.get(`${BASE_URL}/api/schools/schools/${firstVillage.udise_village_code}`);
                    
                    console.log(`✅ [TEST] API Response:`, JSON.stringify(schoolsResponse.data, null, 2));
                    
                    if (schoolsResponse.data.success && schoolsResponse.data.data.totalSchools > 0) {
                        console.log(`🎉 [TEST] SUCCESS! Found ${schoolsResponse.data.data.totalSchools} schools:`);
                        schoolsResponse.data.data.schools.forEach((school, index) => {
                            console.log(`  ${index + 1}. School Name: ${school.school_name}`);
                            console.log(`     School Code: ${school.udise_school_code}`);
                            console.log('');
                        });
                    } else {
                        console.log(`⚠️ [TEST] No schools found for village: ${firstVillage.village_name}`);
                        console.log(`📊 [TEST] Response data:`, schoolsResponse.data);
                    }
                } else {
                    console.log(`⚠️ [TEST] No villages found for district: ${firstDistrict.district_name}`);
                }
            } else {
                console.log(`⚠️ [TEST] No districts found for state: ${firstState.state_name}`);
            }
        } else {
            console.log(`⚠️ [TEST] No states found`);
        }
        
    } catch (error) {
        console.error('❌ [TEST] Test failed:', error.response?.data || error.message);
    }
    
    console.log('\n🎉 [TEST] Schools API test completed!');
}

// Run the test
testSchoolsSimple().catch(console.error);
