const axios = require('axios');

const BASE_URL = 'http://localhost:5500';
const TEST_TOKEN = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6IjY4YzdlZjQxM2M4NjQ3N2IzYjYyNjE3MiIsIm1vYmlsZSI6Ijk1MTU0NDYwODAiLCJpYXQiOjE3NTg2MDkxOTIsImV4cCI6MTc1ODY5NTU5Mn0.3kmZLm2-Jo8gjmBf4L1w7_KG7S_TXpf7vHCln_aKZlM'; // Replace with your actual token
const TEST_USER_ID = '68c7ef413c86477b3b626172'; // Replace with your actual user ID

async function testSchoolCodeLength() {
    console.log('🧪 [TEST] Testing School Code Length Fix...\n');
    
    try {
        // Test with the original data that was failing
        console.log('📝 [TEST] Testing with school code: "MODERN CONVENT SCHOOL" (21 characters)');
        
        const updateData = {
            schoolState: 'Andhra Pradesh',
            schoolDistrict: 'Srikakulam',
            schoolVillage: 'Ponduru',
            schoolCode: 'MODERN CONVENT SCHOOL', // 21 characters
            schoolName: 'MODERN CONVENT SCHOOL',
            class10thStatus: 'completed',
            academicYear: '2018'
        };
        
        const response = await axios.put(`${BASE_URL}/api/users/school-details/${TEST_USER_ID}`, updateData, {
            headers: {
                'Authorization': `Bearer ${TEST_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        
        console.log('✅ [TEST] SUCCESS! School code length fix worked:');
        console.log(JSON.stringify(response.data, null, 2));
        
        // Test with an even longer school code to verify the new limit
        console.log('\n📝 [TEST] Testing with longer school code (35 characters)...');
        
        const longUpdateData = {
            schoolCode: 'VERY LONG SCHOOL CODE NAME EXAMPLE', // 35 characters
            schoolName: 'VERY LONG SCHOOL NAME EXAMPLE'
        };
        
        const longResponse = await axios.put(`${BASE_URL}/api/users/school-details/${TEST_USER_ID}`, longUpdateData, {
            headers: {
                'Authorization': `Bearer ${TEST_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        
        console.log('✅ [TEST] SUCCESS! Longer school code also worked:');
        console.log(JSON.stringify(longResponse.data, null, 2));
        
        // Test the limit (should fail at 51 characters)
        console.log('\n📝 [TEST] Testing with school code that exceeds new limit (51 characters)...');
        
        const tooLongUpdateData = {
            schoolCode: 'A'.repeat(51) // 51 characters - should fail
        };
        
        try {
            await axios.put(`${BASE_URL}/api/users/school-details/${TEST_USER_ID}`, tooLongUpdateData, {
                headers: {
                    'Authorization': `Bearer ${TEST_TOKEN}`,
                    'Content-Type': 'application/json'
                }
            });
            console.log('❌ [TEST] ERROR: Should have failed but didn\'t');
        } catch (error) {
            console.log('✅ [TEST] Expected error for school code exceeding 50 characters:');
            console.log(JSON.stringify(error.response?.data, null, 2));
        }
        
    } catch (error) {
        console.error('❌ [TEST ERROR] Test failed:', {
            message: error.message,
            status: error.response?.status,
            statusText: error.response?.statusText,
            data: error.response?.data
        });
    }
    
    console.log('\n🎉 [TEST] School code length fix test completed!');
}

// Run the test
testSchoolCodeLength().catch(console.error);
