const axios = require('axios');

const BASE_URL = 'http://localhost:5500/api/posts';

// Test function to check posts with interests
async function testPostInterests() {
    console.log('🧪 Testing Posts with Interests API...\n');

    try {
        // Test 1: Get all posts
        console.log('1. Testing GET /api/posts');
        const allPosts = await axios.get(`${BASE_URL}`);
        console.log(`✅ Success: Found ${allPosts.data.data.length} posts`);
        console.log('');

        // Test 2: Get posts by interests
        console.log('2. Testing GET /api/posts/interests/Activism,Archaeology');
        const postsByInterests = await axios.get(`${BASE_URL}/interests/Activism,Archaeology`);
        console.log(`✅ Success: Found ${postsByInterests.data.data.length} posts with interests [Activism, Archaeology]`);
        console.log('');

        // Test 3: Get posts with interests filter
        console.log('3. Testing GET /api/posts?interests=Technology');
        const postsWithTechInterests = await axios.get(`${BASE_URL}?interests=Technology`);
        console.log(`✅ Success: Found ${postsWithTechInterests.data.data.length} posts with Technology interests`);
        console.log('');

        // Test 4: Get posts with multiple interests filter
        console.log('4. Testing GET /api/posts?interests=Technology,Programming');
        const postsWithMultipleInterests = await axios.get(`${BASE_URL}?interests=Technology,Programming`);
        console.log(`✅ Success: Found ${postsWithMultipleInterests.data.data.length} posts with Technology or Programming interests`);
        console.log('');

        console.log('🎉 All tests passed successfully!');
        console.log('\n📋 Posts with Interests API Endpoints:');
        console.log('GET /api/posts - Get all posts (with interests filter)');
        console.log('GET /api/posts?interests=Technology - Filter posts by interests');
        console.log('GET /api/posts?interests=Technology,Programming - Filter by multiple interests');
        console.log('GET /api/posts/interests/:interests - Get posts by specific interests');
        console.log('POST /api/posts - Create post with interests field');
        console.log('PUT /api/posts/:id - Update post interests');

    } catch (error) {
        console.error('❌ Test failed:', error.response?.data || error.message);
        
        if (error.code === 'ECONNREFUSED') {
            console.log('\n💡 Make sure the server is running on http://localhost:5500');
            console.log('   Run: npm start or node server.js');
        }
    }
}

// Run the tests
testPostInterests();
