const axios = require('axios');

const BASE_URL = 'http://localhost:5500/api';
const testUserId = '68c7ef413c86477b3b626172'; // Replace with actual user ID
const testGroupId = '68d2a1ec52d4291170859da5'; // Replace with actual group ID

async function testGroupMembersAPI() {
    console.log('👥 Testing Group Members API\n');
    
    try {
        // Test 1: Get all groups by user ID
        console.log('📋 Test 1: Get all groups by user ID');
        console.log(`GET /api/groups/user/${testUserId}`);
        const response1 = await axios.get(`${BASE_URL}/groups/user/${testUserId}`);
        console.log('✅ Status:', response1.status);
        console.log('📊 Response:', JSON.stringify(response1.data, null, 2));
        console.log('---\n');
        
        // Test 2: Get complete group information by group ID
        console.log('📋 Test 2: Get complete group information by group ID');
        console.log(`GET /api/groups/${testGroupId}`);
        const response2 = await axios.get(`${BASE_URL}/groups/${testGroupId}`);
        console.log('✅ Status:', response2.status);
        console.log('📊 Response:', JSON.stringify(response2.data, null, 2));
        console.log('---\n');
        
        // Test 3: Get all groups (to see all groups in system)
        console.log('📋 Test 3: Get all groups');
        console.log('GET /api/groups');
        const response3 = await axios.get(`${BASE_URL}/groups`);
        console.log('✅ Status:', response3.status);
        console.log('📊 Response:', JSON.stringify(response3.data, null, 2));
        console.log('---\n');
        
        // Test 4: Get groups by school ID (if available)
        console.log('📋 Test 4: Get group by school ID');
        console.log('GET /api/groups/school/SCH001_2023-2024');
        const response4 = await axios.get(`${BASE_URL}/groups/school/SCH001_2023-2024`);
        console.log('✅ Status:', response4.status);
        console.log('📊 Response:', JSON.stringify(response4.data, null, 2));
        console.log('---\n');
        
        // Test 5: Get group by college ID (if available)
        console.log('📋 Test 5: Get group by college ID');
        console.log('GET /api/groups/college/C-35789_2023-2027_Bachelor of Computer Science_Computer Science and Engineering');
        const response5 = await axios.get(`${BASE_URL}/groups/college/C-35789_2023-2027_Bachelor of Computer Science_Computer Science and Engineering`);
        console.log('✅ Status:', response5.status);
        console.log('📊 Response:', JSON.stringify(response5.data, null, 2));
        console.log('---\n');
        
    } catch (error) {
        console.error('❌ Test failed:', error.response?.data || error.message);
        console.error('❌ Full error:', error);
    }
}

// Run the test
testGroupMembersAPI();
