const axios = require('axios');

const BASE_URL = 'http://localhost:5500/api';
const testUserId = '68c7ef413c86477b3b626172'; // Replace with actual user ID
const authToken = 'YOUR_JWT_TOKEN_HERE'; // Replace with actual JWT token

const headers = {
    'Authorization': `Bearer ${authToken}`,
    'Content-Type': 'application/json'
};

async function testCutsByUserIdAPI() {
    console.log('🎬 Testing Cuts by User ID API\n');
    
    try {
        // Test 1: Get cuts by user ID (basic)
        console.log('📋 Test 1: Get cuts by user ID');
        console.log(`GET /api/cuts/user/${testUserId}`);
        const response1 = await axios.get(`${BASE_URL}/cuts/user/${testUserId}`);
        console.log('✅ Status:', response1.status);
        console.log('📊 Response:', JSON.stringify(response1.data, null, 2));
        console.log('---\n');
        
        // Test 2: Get cuts by user ID with pagination
        console.log('📋 Test 2: Get cuts by user ID with pagination');
        console.log(`GET /api/cuts/user/${testUserId}?page=1&limit=5`);
        const response2 = await axios.get(`${BASE_URL}/cuts/user/${testUserId}?page=1&limit=5`);
        console.log('✅ Status:', response2.status);
        console.log('📊 Response:', JSON.stringify(response2.data, null, 2));
        console.log('---\n');
        
        // Test 3: Get cuts by user ID with different page
        console.log('📋 Test 3: Get cuts by user ID - page 2');
        console.log(`GET /api/cuts/user/${testUserId}?page=2&limit=3`);
        const response3 = await axios.get(`${BASE_URL}/cuts/user/${testUserId}?page=2&limit=3`);
        console.log('✅ Status:', response3.status);
        console.log('📊 Response:', JSON.stringify(response3.data, null, 2));
        console.log('---\n');
        
        // Test 4: Test with invalid user ID
        console.log('📋 Test 4: Test with invalid user ID');
        console.log('GET /api/cuts/user/invalid_user_id');
        try {
            const response4 = await axios.get(`${BASE_URL}/cuts/user/invalid_user_id`);
            console.log('❌ Unexpected success:', response4.data);
        } catch (error) {
            if (error.response?.status === 400) {
                console.log('✅ Correctly returns 400 Bad Request for invalid user ID');
                console.log('📊 Error Response:', JSON.stringify(error.response.data, null, 2));
            } else {
                console.log('❌ Unexpected error:', error.response?.data || error.message);
            }
        }
        console.log('---\n');
        
        // Test 5: Test with non-existent user ID
        console.log('📋 Test 5: Test with non-existent user ID');
        console.log('GET /api/cuts/user/68c7ef413c86477b3b626999');
        try {
            const response5 = await axios.get(`${BASE_URL}/cuts/user/68c7ef413c86477b3b626999`);
            console.log('✅ Status:', response5.status);
            console.log('📊 Response:', JSON.stringify(response5.data, null, 2));
            
            if (response5.data.data.cuts.length === 0) {
                console.log('✅ Correctly returns empty array for non-existent user');
            }
        } catch (error) {
            console.log('❌ Unexpected error:', error.response?.data || error.message);
        }
        console.log('---\n');
        
        // Test 6: Get cuts by user ID with large limit
        console.log('📋 Test 6: Get cuts by user ID with large limit');
        console.log(`GET /api/cuts/user/${testUserId}?page=1&limit=50`);
        const response6 = await axios.get(`${BASE_URL}/cuts/user/${testUserId}?page=1&limit=50`);
        console.log('✅ Status:', response6.status);
        console.log('📊 Response:', JSON.stringify(response6.data, null, 2));
        console.log('---\n');
        
        console.log('🎯 API Endpoint Summary:');
        console.log('✅ GET /api/cuts/user/:userId - Get cuts by user ID');
        console.log('✅ Supports pagination: ?page=1&limit=10');
        console.log('✅ Returns cuts with user details and engagement metrics');
        console.log('✅ Handles invalid user IDs gracefully');
        console.log('✅ Returns empty array for users with no cuts');
        
    } catch (error) {
        console.error('❌ Test failed:', error.response?.data || error.message);
        console.error('❌ Full error:', error);
        
        if (error.response?.status === 404) {
            console.log('\n💡 Route not found. Please check:');
            console.log('1. Server is running on the correct port');
            console.log('2. Cuts routes are properly registered in server.js');
            console.log('3. Route path is correct: /api/cuts/user/:userId');
        }
    }
}

// Run the test
testCutsByUserIdAPI();
