const axios = require('axios');
const FormData = require('form-data');
const fs = require('fs');
const path = require('path');

const BASE_URL = 'http://localhost:5500/api';
const testUserId = '68c7ef413c86477b3b626172'; // Replace with actual user ID
const authToken = 'YOUR_JWT_TOKEN_HERE'; // Replace with actual JWT token

const headers = {
    'Authorization': `Bearer ${authToken}`
};

async function testCutsAPI() {
    console.log('🎬 Testing Cuts API\n');
    
    try {
        // Test 1: Create a cut (with video file)
        console.log('📋 Test 1: Create a cut');
        console.log('POST /api/cuts');
        
        const formData = new FormData();
        formData.append('user_id', testUserId); // Add user_id to request body
        formData.append('title', 'My Amazing Video Cut');
        formData.append('description', 'This is a test video cut with amazing content');
        formData.append('visibility', 'public');
        formData.append('interests', JSON.stringify(['Technology', 'Entertainment']));
        formData.append('tags', JSON.stringify(['test', 'demo', 'video']));
        
        // Create a dummy video file for testing
        const dummyVideoPath = path.join(__dirname, 'test-video.mp4');
        if (!fs.existsSync(dummyVideoPath)) {
            // Create a small dummy video file (1KB)
            fs.writeFileSync(dummyVideoPath, Buffer.alloc(1024));
        }
        formData.append('video', fs.createReadStream(dummyVideoPath));
        
        const response1 = await axios.post(`${BASE_URL}/cuts`, formData, {
            headers: {
                ...headers,
                ...formData.getHeaders()
            }
        });
        console.log('✅ Status:', response1.status);
        console.log('📊 Response:', JSON.stringify(response1.data, null, 2));
        const cutId = response1.data.data.cut._id;
        console.log('---\n');
        
        // Test 2: Get all cuts
        console.log('📋 Test 2: Get all cuts');
        console.log('GET /api/cuts');
        const response2 = await axios.get(`${BASE_URL}/cuts`);
        console.log('✅ Status:', response2.status);
        console.log('📊 Response:', JSON.stringify(response2.data, null, 2));
        console.log('---\n');
        
        // Test 3: Get cut by ID
        console.log('📋 Test 3: Get cut by ID');
        console.log(`GET /api/cuts/${cutId}`);
        const response3 = await axios.get(`${BASE_URL}/cuts/${cutId}`);
        console.log('✅ Status:', response3.status);
        console.log('📊 Response:', JSON.stringify(response3.data, null, 2));
        console.log('---\n');
        
        // Test 4: Get cuts by user
        console.log('📋 Test 4: Get cuts by user');
        console.log(`GET /api/cuts/user/${testUserId}`);
        const response4 = await axios.get(`${BASE_URL}/cuts/user/${testUserId}`);
        console.log('✅ Status:', response4.status);
        console.log('📊 Response:', JSON.stringify(response4.data, null, 2));
        console.log('---\n');
        
        // Test 5: Get cuts by interests
        console.log('📋 Test 5: Get cuts by interests');
        console.log('GET /api/cuts/interests/Technology,Entertainment');
        const response5 = await axios.get(`${BASE_URL}/cuts/interests/Technology,Entertainment`);
        console.log('✅ Status:', response5.status);
        console.log('📊 Response:', JSON.stringify(response5.data, null, 2));
        console.log('---\n');
        
        // Test 6: Get trending cuts
        console.log('📋 Test 6: Get trending cuts');
        console.log('GET /api/cuts/trending');
        const response6 = await axios.get(`${BASE_URL}/cuts/trending`);
        console.log('✅ Status:', response6.status);
        console.log('📊 Response:', JSON.stringify(response6.data, null, 2));
        console.log('---\n');
        
        // Test 7: Like a cut
        console.log('📋 Test 7: Like a cut');
        console.log(`POST /api/cuts/${cutId}/like`);
        const response7 = await axios.post(`${BASE_URL}/cuts/${cutId}/like`, {}, { headers });
        console.log('✅ Status:', response7.status);
        console.log('📊 Response:', JSON.stringify(response7.data, null, 2));
        console.log('---\n');
        
        // Test 8: Add comment to cut
        console.log('📋 Test 8: Add comment to cut');
        console.log(`POST /api/cuts/${cutId}/comment`);
        const response8 = await axios.post(`${BASE_URL}/cuts/${cutId}/comment`, {
            comment: 'This is an amazing video cut! Great work!'
        }, { headers });
        console.log('✅ Status:', response8.status);
        console.log('📊 Response:', JSON.stringify(response8.data, null, 2));
        console.log('---\n');
        
        // Test 9: Share a cut
        console.log('📋 Test 9: Share a cut');
        console.log(`POST /api/cuts/${cutId}/share`);
        const response9 = await axios.post(`${BASE_URL}/cuts/${cutId}/share`, {}, { headers });
        console.log('✅ Status:', response9.status);
        console.log('📊 Response:', JSON.stringify(response9.data, null, 2));
        console.log('---\n');
        
        // Test 10: Update cut
        console.log('📋 Test 10: Update cut');
        console.log(`PUT /api/cuts/${cutId}`);
        const response10 = await axios.put(`${BASE_URL}/cuts/${cutId}`, {
            title: 'Updated Amazing Video Cut',
            description: 'This is an updated description for the video cut',
            visibility: 'private',
            interests: ['Technology', 'Gaming'],
            tags: ['updated', 'demo', 'video']
        }, { headers });
        console.log('✅ Status:', response10.status);
        console.log('📊 Response:', JSON.stringify(response10.data, null, 2));
        console.log('---\n');
        
        // Test 11: Get updated cut
        console.log('📋 Test 11: Get updated cut');
        console.log(`GET /api/cuts/${cutId}`);
        const response11 = await axios.get(`${BASE_URL}/cuts/${cutId}`);
        console.log('✅ Status:', response11.status);
        console.log('📊 Response:', JSON.stringify(response11.data, null, 2));
        console.log('---\n');
        
        // Test 12: Unlike a cut
        console.log('📋 Test 12: Unlike a cut');
        console.log(`POST /api/cuts/${cutId}/like`);
        const response12 = await axios.post(`${BASE_URL}/cuts/${cutId}/like`, {}, { headers });
        console.log('✅ Status:', response12.status);
        console.log('📊 Response:', JSON.stringify(response12.data, null, 2));
        console.log('---\n');
        
        // Test 13: Delete cut
        console.log('📋 Test 13: Delete cut');
        console.log(`DELETE /api/cuts/${cutId}`);
        const response13 = await axios.delete(`${BASE_URL}/cuts/${cutId}`, { headers });
        console.log('✅ Status:', response13.status);
        console.log('📊 Response:', JSON.stringify(response13.data, null, 2));
        console.log('---\n');
        
        // Test 14: Get cuts with filters
        console.log('📋 Test 14: Get cuts with filters');
        console.log('GET /api/cuts?visibility=public&page=1&limit=5&sortBy=createdAt&sortOrder=desc');
        const response14 = await axios.get(`${BASE_URL}/cuts?visibility=public&page=1&limit=5&sortBy=createdAt&sortOrder=desc`);
        console.log('✅ Status:', response14.status);
        console.log('📊 Response:', JSON.stringify(response14.data, null, 2));
        console.log('---\n');
        
        // Clean up dummy video file
        if (fs.existsSync(dummyVideoPath)) {
            fs.unlinkSync(dummyVideoPath);
        }
        
    } catch (error) {
        console.error('❌ Test failed:', error.response?.data || error.message);
        console.error('❌ Full error:', error);
    }
}

// Run the test
testCutsAPI();
