const axios = require('axios');

const BASE_URL = 'http://localhost:5500';

async function testCollegeAPI() {
    console.log('🧪 [TEST] Testing College API...\n');
    
    const testCases = [
        {
            name: 'Search colleges by name',
            url: '/api/colleges/search?name=Government&limit=5',
            method: 'GET'
        },
        {
            name: 'Get all states',
            url: '/api/colleges/states',
            method: 'GET'
        },
        {
            name: 'Get all cities',
            url: '/api/colleges/cities',
            method: 'GET'
        },
        {
            name: 'Get colleges by state',
            url: '/api/colleges/state/Tamil Nadu',
            method: 'GET'
        },
        {
            name: 'Get colleges by city',
            url: '/api/colleges/city/Tiruchirappalli',
            method: 'GET'
        },
        {
            name: 'Get college by AISHE code',
            url: '/api/colleges/aishe/C-35789',
            method: 'GET'
        }
    ];
    
    for (const testCase of testCases) {
        try {
            console.log(`📝 [TEST] ${testCase.name}...`);
            console.log(`📝 [TEST] URL: ${testCase.url}`);
            
            const response = await axios.get(`${BASE_URL}${testCase.url}`);
            
            console.log(`✅ [TEST] ${testCase.name} - SUCCESS`);
            console.log(`✅ [TEST] Response:`, JSON.stringify(response.data, null, 2));
            
            // Show sample data if available
            if (response.data.success && response.data.data) {
                if (response.data.data.colleges && response.data.data.colleges.length > 0) {
                    console.log(`📊 [TEST] Sample college data:`);
                    response.data.data.colleges.slice(0, 2).forEach((college, index) => {
                        console.log(`  ${index + 1}. ${college.instituteName} (${college.aisheCode})`);
                        console.log(`     City: ${college.city}, State: ${college.state}`);
                    });
                } else if (response.data.data.states && response.data.data.states.length > 0) {
                    console.log(`📊 [TEST] Sample states:`, response.data.data.states.slice(0, 5));
                } else if (response.data.data.cities && response.data.data.cities.length > 0) {
                    console.log(`📊 [TEST] Sample cities:`, response.data.data.cities.slice(0, 5));
                } else if (response.data.data.college) {
                    console.log(`📊 [TEST] College found:`, response.data.data.college.instituteName);
                }
            }
            
        } catch (error) {
            console.log(`❌ [TEST] ${testCase.name} - ERROR`);
            console.log(`❌ [TEST] Error:`, error.response?.data || error.message);
        }
        
        console.log('---\n');
    }
    
    // Test search functionality with different terms
    console.log('🔍 [TEST] Testing search functionality with different terms...\n');
    
    const searchTerms = ['Government', 'Arts', 'Engineering', 'Medical', 'University'];
    
    for (const term of searchTerms) {
        try {
            console.log(`📝 [TEST] Searching for: "${term}"`);
            const response = await axios.get(`${BASE_URL}/api/colleges/search?name=${term}&limit=3`);
            
            if (response.data.success && response.data.data.colleges.length > 0) {
                console.log(`✅ [TEST] Found ${response.data.data.colleges.length} colleges for "${term}"`);
                response.data.data.colleges.forEach((college, index) => {
                    console.log(`  ${index + 1}. ${college.instituteName}`);
                });
            } else {
                console.log(`⚠️ [TEST] No colleges found for "${term}"`);
            }
            
        } catch (error) {
            console.log(`❌ [TEST] Search failed for "${term}":`, error.response?.data?.message || error.message);
        }
        
        console.log('');
    }
    
    console.log('🎉 [TEST] College API tests completed!');
}

// Run the test
testCollegeAPI().catch(console.error);
