const mongoose = require('mongoose');
require('dotenv').config();

// Import models
const Exam = require('../models/Exam');
const College = require('../models/College');
const Quiz = require('../models/Quiz');
const CareerPath = require('../models/CareerPath');
const Certification = require('../models/Certification');
const connectDB = require('../utils/db');

// More comprehensive exam data
const moreExams = [
    // Class 6-10 Exams
    {
        name: "APRJC",
        fullForm: "Andhra Pradesh Residential Junior College",
        stage: "class_6_10",
        category: "entrance",
        conductingBody: "AP Residential Educational Institutions Society",
        eligibility: {
            minAge: 10,
            maxAge: 12,
            education: "Class 5 completed",
            percentage: 60
        },
        examPattern: {
            mode: "offline",
            duration: 120,
            totalMarks: 100,
            sections: [
                { name: "Mathematics", marks: 40, questions: 40, duration: 60 },
                { name: "General Knowledge", marks: 30, questions: 30, duration: 30 },
                { name: "Telugu/English", marks: 30, questions: 30, duration: 30 }
            ]
        },
        syllabus: ["Mathematics", "General Knowledge", "Language"],
        applicationFee: { general: 200, reserved: 100 },
        importantDates: {
            applicationStart: new Date('2024-02-01'),
            applicationEnd: new Date('2024-03-15'),
            examDate: new Date('2024-04-20'),
            resultDate: new Date('2024-05-15')
        },
        cutoffs: { general: 80, obc: 75, sc: 70, st: 70, ews: 75 },
        topColleges: ["APRJC Kurnool", "APRJC Kadapa", "APRJC Anantapur"],
        studyTips: ["Practice basic mathematics", "Read daily newspapers", "Improve language skills"],
        officialWebsite: "https://apresidential.gov.in"
    },
    {
        name: "KVPY",
        fullForm: "Kishore Vaigyanik Protsahan Yojana",
        stage: "class_6_10",
        category: "competitive",
        conductingBody: "Indian Institute of Science",
        eligibility: {
            minAge: 16,
            maxAge: 19,
            education: "Class 11 with Science",
            percentage: 75
        },
        examPattern: {
            mode: "offline",
            duration: 180,
            totalMarks: 100,
            sections: [
                { name: "Mathematics", marks: 25, questions: 25, duration: 45 },
                { name: "Physics", marks: 25, questions: 25, duration: 45 },
                { name: "Chemistry", marks: 25, questions: 25, duration: 45 },
                { name: "Biology", marks: 25, questions: 25, duration: 45 }
            ]
        },
        syllabus: ["Mathematics", "Physics", "Chemistry", "Biology"],
        applicationFee: { general: 1000, reserved: 500 },
        importantDates: {
            applicationStart: new Date('2024-07-01'),
            applicationEnd: new Date('2024-08-31'),
            examDate: new Date('2024-11-03'),
            resultDate: new Date('2024-12-15')
        },
        cutoffs: { general: 70, obc: 65, sc: 60, st: 60, ews: 65 },
        topColleges: ["IISc Bangalore", "IITs", "NISER", "CEBS"],
        studyTips: ["Strong conceptual understanding", "Problem-solving approach", "Regular practice"],
        officialWebsite: "https://kvpy.iisc.ernet.in"
    },
    // Class 11-12 Exams
    {
        name: "JEE Advanced",
        fullForm: "Joint Entrance Examination Advanced",
        stage: "class_11_12",
        category: "entrance",
        conductingBody: "Indian Institutes of Technology",
        eligibility: {
            minAge: 17,
            maxAge: 25,
            education: "JEE Main qualified",
            percentage: 75
        },
        examPattern: {
            mode: "online",
            duration: 360,
            totalMarks: 306,
            sections: [
                { name: "Physics", marks: 102, questions: 18, duration: 180 },
                { name: "Chemistry", marks: 102, questions: 18, duration: 180 },
                { name: "Mathematics", marks: 102, questions: 18, duration: 180 }
            ]
        },
        syllabus: ["Physics", "Chemistry", "Mathematics"],
        applicationFee: { general: 2800, reserved: 1400 },
        importantDates: {
            applicationStart: new Date('2024-04-30'),
            applicationEnd: new Date('2024-05-15'),
            examDate: new Date('2024-06-02'),
            resultDate: new Date('2024-06-18')
        },
        cutoffs: { general: 120, obc: 108, sc: 54, st: 54, ews: 108 },
        topColleges: ["All IITs", "IISc Bangalore"],
        studyTips: ["Master JEE Main concepts", "Practice advanced problems", "Time management"],
        officialWebsite: "https://jeeadv.ac.in"
    },
    {
        name: "CLAT",
        fullForm: "Common Law Admission Test",
        stage: "class_11_12",
        category: "entrance",
        conductingBody: "Consortium of NLUs",
        eligibility: {
            minAge: 20,
            maxAge: 22,
            education: "Class 12 with 45% marks",
            percentage: 45
        },
        examPattern: {
            mode: "online",
            duration: 120,
            totalMarks: 150,
            sections: [
                { name: "English", marks: 30, questions: 30, duration: 24 },
                { name: "Current Affairs", marks: 30, questions: 30, duration: 24 },
                { name: "Legal Reasoning", marks: 40, questions: 40, duration: 32 },
                { name: "Logical Reasoning", marks: 30, questions: 30, duration: 24 },
                { name: "Quantitative Techniques", marks: 20, questions: 20, duration: 16 }
            ]
        },
        syllabus: ["English", "Current Affairs", "Legal Reasoning", "Logical Reasoning", "Quantitative Techniques"],
        applicationFee: { general: 4000, reserved: 3500 },
        importantDates: {
            applicationStart: new Date('2024-01-01'),
            applicationEnd: new Date('2024-03-31'),
            examDate: new Date('2024-05-26'),
            resultDate: new Date('2024-06-10')
        },
        cutoffs: { general: 85, obc: 75, sc: 65, st: 65, ews: 75 },
        topColleges: ["NLSIU Bangalore", "NALSAR Hyderabad", "NLIU Bhopal"],
        studyTips: ["Read newspapers daily", "Practice legal reasoning", "Improve English"],
        officialWebsite: "https://consortiumofnlus.ac.in"
    },
    // Graduation Exams
    {
        name: "GATE",
        fullForm: "Graduate Aptitude Test in Engineering",
        stage: "graduation",
        category: "competitive",
        conductingBody: "IITs and IISc",
        eligibility: {
            minAge: 21,
            maxAge: 30,
            education: "B.Tech/B.E or equivalent",
            percentage: 60
        },
        examPattern: {
            mode: "online",
            duration: 180,
            totalMarks: 100,
            sections: [
                { name: "Technical", marks: 70, questions: 55, duration: 150 },
                { name: "General Aptitude", marks: 30, questions: 10, duration: 30 }
            ]
        },
        syllabus: ["Technical subjects", "General Aptitude", "Engineering Mathematics"],
        applicationFee: { general: 1500, reserved: 750 },
        importantDates: {
            applicationStart: new Date('2024-08-30'),
            applicationEnd: new Date('2024-10-12'),
            examDate: new Date('2025-02-01'),
            resultDate: new Date('2025-03-16')
        },
        cutoffs: { general: 35, obc: 31, sc: 23, st: 23, ews: 31 },
        topColleges: ["IITs", "NITs", "IISc", "IIITs"],
        studyTips: ["Strong technical foundation", "Practice previous year papers", "Time management"],
        officialWebsite: "https://gate.iitk.ac.in"
    },
    {
        name: "CAT",
        fullForm: "Common Admission Test",
        stage: "graduation",
        category: "competitive",
        conductingBody: "Indian Institutes of Management",
        eligibility: {
            minAge: 21,
            maxAge: 30,
            education: "Graduation with 50% marks",
            percentage: 50
        },
        examPattern: {
            mode: "online",
            duration: 180,
            totalMarks: 300,
            sections: [
                { name: "Verbal Ability", marks: 100, questions: 34, duration: 60 },
                { name: "Data Interpretation", marks: 100, questions: 32, duration: 60 },
                { name: "Quantitative Ability", marks: 100, questions: 34, duration: 60 }
            ]
        },
        syllabus: ["Verbal Ability", "Data Interpretation", "Quantitative Ability"],
        applicationFee: { general: 2300, reserved: 1150 },
        importantDates: {
            applicationStart: new Date('2024-08-01'),
            applicationEnd: new Date('2024-09-20'),
            examDate: new Date('2024-11-24'),
            resultDate: new Date('2024-12-21')
        },
        cutoffs: { general: 95, obc: 85, sc: 75, st: 75, ews: 85 },
        topColleges: ["IIM Ahmedabad", "IIM Bangalore", "IIM Calcutta"],
        studyTips: ["Strong quantitative skills", "Reading comprehension", "Data interpretation"],
        officialWebsite: "https://iimcat.ac.in"
    }
];

// More comprehensive college data
const moreColleges = [
    {
        name: "Indian Institute of Technology Bombay",
        type: "government",
        category: "iit",
        location: {
            state: "Maharashtra",
            city: "Mumbai",
            pincode: "400076",
            address: "Powai, Mumbai"
        },
        courses: [
            { name: "B.Tech Computer Science", duration: 4, type: "btech", specializations: ["AI/ML", "Data Science", "Cybersecurity"] },
            { name: "B.Tech Electrical", duration: 4, type: "btech", specializations: ["Power Systems", "Electronics"] },
            { name: "M.Tech Computer Science", duration: 2, type: "mtech", specializations: ["AI", "ML", "Systems"] }
        ],
        cutoffs: [
            { course: "B.Tech Computer Science", category: "general", exam: "JEE Advanced", cutoffRank: 150, year: 2023 },
            { course: "B.Tech Electrical", category: "general", exam: "JEE Advanced", cutoffRank: 800, year: 2023 }
        ],
        fees: {
            tuitionFee: 100000,
            hostelFee: 55000,
            otherCharges: 25000,
            totalFirstYear: 180000
        },
        placement: {
            averagePackage: 1800000,
            highestPackage: 6000000,
            placementPercentage: 98,
            topRecruiters: ["Google", "Microsoft", "Amazon", "Goldman Sachs"],
            year: 2023
        },
        facilities: ["Library", "Hostel", "Sports Complex", "Research Labs", "Incubation Center"],
        website: "https://www.iitb.ac.in",
        contact: { phone: "022-25722545", email: "admin@iitb.ac.in" },
        ranking: { nirf: 3, times: 3, outlook: 2, year: 2023 }
    },
    {
        name: "National Institute of Technology Trichy",
        type: "government",
        category: "nit",
        location: {
            state: "Tamil Nadu",
            city: "Tiruchirappalli",
            pincode: "620015",
            address: "Tanjavur Main Road, Tiruchirappalli"
        },
        courses: [
            { name: "B.Tech Computer Science", duration: 4, type: "btech", specializations: ["Software Engineering", "Data Science"] },
            { name: "B.Tech Mechanical", duration: 4, type: "btech", specializations: ["Manufacturing", "Thermal"] },
            { name: "M.Tech Computer Science", duration: 2, type: "mtech", specializations: ["AI", "Networks"] }
        ],
        cutoffs: [
            { course: "B.Tech Computer Science", category: "general", exam: "JEE Main", cutoffRank: 500, year: 2023 },
            { course: "B.Tech Mechanical", category: "general", exam: "JEE Main", cutoffRank: 2000, year: 2023 }
        ],
        fees: {
            tuitionFee: 62500,
            hostelFee: 15000,
            otherCharges: 15000,
            totalFirstYear: 92500
        },
        placement: {
            averagePackage: 1200000,
            highestPackage: 4000000,
            placementPercentage: 95,
            topRecruiters: ["TCS", "Infosys", "Wipro", "Amazon"],
            year: 2023
        },
        facilities: ["Library", "Hostel", "Sports Complex", "Cafeteria"],
        website: "https://www.nitt.edu",
        contact: { phone: "0431-2503001", email: "admin@nitt.edu" },
        ranking: { nirf: 5, times: 8, outlook: 6, year: 2023 }
    }
];

// More quiz questions
const moreQuizzes = [
    {
        question: "Which planet is known as the Red Planet?",
        options: ["Venus", "Mars", "Jupiter", "Saturn"],
        correctAnswer: 1,
        explanation: "Mars is known as the Red Planet due to its reddish appearance.",
        category: "science",
        difficulty: "easy",
        stage: "class_6_10",
        tags: ["astronomy", "planets"],
        source: "Astronomy"
    },
    {
        question: "Who wrote the book 'War and Peace'?",
        options: ["Fyodor Dostoevsky", "Leo Tolstoy", "Anton Chekhov", "Nikolai Gogol"],
        correctAnswer: 1,
        explanation: "Leo Tolstoy wrote the famous novel 'War and Peace'.",
        category: "history",
        difficulty: "medium",
        stage: "class_11_12",
        tags: ["literature", "russian literature"],
        source: "World Literature"
    },
    {
        question: "What is the currency of Japan?",
        options: ["Won", "Yuan", "Yen", "Dong"],
        correctAnswer: 2,
        explanation: "The currency of Japan is Yen.",
        category: "geography",
        difficulty: "easy",
        stage: "class_6_10",
        tags: ["currency", "japan"],
        source: "General Knowledge"
    },
    {
        question: "Which programming language was created by Guido van Rossum?",
        options: ["Java", "Python", "C++", "JavaScript"],
        correctAnswer: 1,
        explanation: "Python was created by Guido van Rossum.",
        category: "technology",
        difficulty: "medium",
        stage: "class_11_12",
        tags: ["programming", "python"],
        source: "Computer Science"
    }
];

// More career paths
const moreCareerPaths = [
    {
        name: "Commerce",
        stage: "class_11_12",
        description: "Commerce involves the study of trade, business, finance, and economics. It provides knowledge about commercial activities and business operations.",
        prerequisites: ["Mathematics", "English", "Business Studies"],
        duration: "3 years (B.Com)",
        salaryRange: { min: 250000, max: 800000 },
        jobRoles: ["Accountant", "Business Analyst", "Financial Advisor", "Banking Professional"],
        skillsRequired: ["Numerical Skills", "Analytical Thinking", "Communication", "Problem Solving"],
        exams: ["CUET", "IPU CET", "NPAT", "Symbiosis SET"],
        topColleges: ["Delhi University", "Christ University", "Xavier's College", "Symbiosis"],
        pros: ["Good job opportunities", "Stable career", "Various specializations", "Good work-life balance"],
        cons: ["Moderate salary growth", "Competitive field", "Requires continuous learning"],
        famousPersonalities: [
            { name: "Raghuram Rajan", profession: "Former RBI Governor", achievement: "Led economic reforms" },
            { name: "Nandan Nilekani", profession: "Co-founder Infosys", achievement: "Pioneered IT revolution" }
        ],
        futureScope: "Commerce field is expanding with digital banking, fintech, and e-commerce opportunities.",
        difficulty: "medium",
        demand: "high"
    },
    {
        name: "Arts/Humanities",
        stage: "class_11_12",
        description: "Arts and Humanities focus on human culture, literature, history, and social sciences. It develops critical thinking and communication skills.",
        prerequisites: ["English", "History", "Political Science"],
        duration: "3 years (BA)",
        salaryRange: { min: 200000, max: 600000 },
        jobRoles: ["Journalist", "Teacher", "Writer", "Social Worker", "Civil Servant"],
        skillsRequired: ["Communication", "Critical Thinking", "Research Skills", "Writing"],
        exams: ["CUET", "DUET", "JNUEE", "UPSC"],
        topColleges: ["Delhi University", "JNU", "Jamia Millia", "St. Stephen's"],
        pros: ["Diverse career options", "Creative opportunities", "Social impact", "Intellectual growth"],
        cons: ["Lower initial salaries", "Limited technical skills", "Competitive government jobs"],
        famousPersonalities: [
            { name: "Arundhati Roy", profession: "Writer", achievement: "Booker Prize winner" },
            { name: "Amartya Sen", profession: "Economist", achievement: "Nobel Prize winner" }
        ],
        futureScope: "Arts graduates are finding opportunities in content creation, social media, and digital marketing.",
        difficulty: "easy",
        demand: "medium"
    }
];

// More certifications
const moreCertifications = [
    {
        name: "Google Cloud Professional Cloud Architect",
        provider: "Google",
        category: "cloud_computing",
        level: "advanced",
        duration: "4-8 months",
        cost: { amount: 20000, currency: "INR" },
        prerequisites: ["Cloud computing basics", "Linux knowledge", "Networking basics"],
        syllabus: ["Google Cloud Platform", "Architecture Design", "Security", "Cost Management"],
        examFormat: "Hands-on lab + Multiple choice",
        validity: "2 years",
        salaryIncrease: { percentage: 30, description: "Average 30% salary increase" },
        jobOpportunities: ["Cloud Architect", "DevOps Engineer", "Solutions Engineer"],
        difficulty: "hard",
        demand: "high",
        website: "https://cloud.google.com/certification"
    },
    {
        name: "PMP - Project Management Professional",
        provider: "PMI",
        category: "management",
        level: "advanced",
        duration: "6-12 months",
        cost: { amount: 35000, currency: "INR" },
        prerequisites: ["Project management experience", "35 hours PM training"],
        syllabus: ["Project Integration", "Scope Management", "Time Management", "Cost Management"],
        examFormat: "Multiple choice questions",
        validity: "3 years",
        salaryIncrease: { percentage: 20, description: "Average 20% salary increase" },
        jobOpportunities: ["Project Manager", "Program Manager", "Portfolio Manager"],
        difficulty: "hard",
        demand: "high",
        website: "https://www.pmi.org/certifications"
    }
];

// Function to seed more data
async function seedMoreCareerData() {
    try {
        await connectDB();
        console.log('Connected to database');

        // Insert more data
        await Exam.insertMany(moreExams);
        console.log('✅ Inserted more exams');

        await College.insertMany(moreColleges);
        console.log('✅ Inserted more colleges');

        await Quiz.insertMany(moreQuizzes);
        console.log('✅ Inserted more quiz questions');

        await CareerPath.insertMany(moreCareerPaths);
        console.log('✅ Inserted more career paths');

        await Certification.insertMany(moreCertifications);
        console.log('✅ Inserted more certifications');

        console.log('🎉 More career data seeding completed successfully!');
        process.exit(0);
    } catch (error) {
        console.error('❌ Error seeding more career data:', error);
        process.exit(1);
    }
}

// Run the seeding function
seedMoreCareerData();
