const express = require('express');
const router = express.Router();
const {
    createOrUpdateWorkingProfessionalDetails,
    getWorkingProfessionalDetails,
    getWorkingProfessionalDetailsById,
    addJobEntry,
    updateJobEntry,
    deleteJobEntry,
    deleteWorkingProfessionalDetails,
    getWorkingProfessionalCompletion,
    getAllWorkingProfessionalDetails
} = require('../controllers/workingProfessionalController');

const { authenticateToken } = require('../middleware/auth');
const { requestSizeLimiter } = require('../middleware/security');
const { 
    validateWorkingProfessionalDetails,
    validateJobEntry
} = require('../middleware/validation');

// Apply authentication to all routes
router.use(authenticateToken);

// Apply request size limiting to all routes
router.use(requestSizeLimiter);

// Create or update working professional details
router.post('/', 
    validateWorkingProfessionalDetails,
    createOrUpdateWorkingProfessionalDetails
);

// Get working professional details for current user
router.get('/', getWorkingProfessionalDetails);

// Get working professional details by ID
router.get('/:id', getWorkingProfessionalDetailsById);

// Delete working professional details
router.delete('/', deleteWorkingProfessionalDetails);

// Get working professional completion status
router.get('/completion/status', getWorkingProfessionalCompletion);

// Job entry specific routes
router.post('/job-entries', 
    validateJobEntry,
    addJobEntry
);

router.put('/job-entries/:jobEntryId', 
    validateJobEntry,
    updateJobEntry
);

router.delete('/job-entries/:jobEntryId', deleteJobEntry);

// Admin routes
router.get('/admin/all', getAllWorkingProfessionalDetails);

module.exports = router;
