const express = require('express');
const router = express.Router();
const {
    getAllGroups,
    getUserGroups,
    getUserGroupsById,
    getGroupById,
    getGroupBySchoolId,
    getGroupByCollegeId,
    createGroup,
    updateGroup,
    deleteGroup,
    joinGroup,
    leaveGroup,
    demoJoinGroup,
    findOrCreateSchoolGroup
} = require('../controllers/groupController');
const { authenticateToken } = require('../middleware/auth');

// Public routes (no authentication required)

// Get all groups
router.get('/', getAllGroups);

// Get group by ID
router.get('/:groupId', getGroupById);

// Get group by school ID
router.get('/school/:schoolId', getGroupBySchoolId);

// Get group by college ID
router.get('/college/:collegeId', getGroupByCollegeId);

// Get groups by user (from user's group IDs)
router.get('/user/:userId', getUserGroupsById);

// Get groups by user (alternative method)
router.get('/user/:userId/groups', getUserGroups);

// Protected routes (authentication required)

// Create group
router.post('/', authenticateToken, createGroup);

// Update group
router.put('/:groupId', authenticateToken, updateGroup);

// Delete group
router.delete('/:groupId', authenticateToken, deleteGroup);

// Demo API - Simple join group (only userId and groupId required)
router.post('/demo/join', demoJoinGroup);

// Join group
router.post('/:groupId/join', joinGroup);

// Leave group
router.post('/:groupId/leave', leaveGroup);

// Find or create school group (for school details update)
router.post('/school/find-or-create', authenticateToken, findOrCreateSchoolGroup);

module.exports = router;
