const express = require('express');
const router = express.Router();
const {
    createOrUpdateGraduateDetails,
    getGraduateDetails,
    getGraduateDetailsById,
    updateGraduateDetails,
    deleteGraduateDetails,
    getGraduateCompletion,
    getColleges,
    getSchools,
    getAllGraduateDetails
} = require('../controllers/graduateDetailsController');

const { authenticateToken } = require('../middleware/auth');
const { requestSizeLimiter } = require('../middleware/security');
const { 
    validateGraduateDetails, 
    validateGraduateDetailsUpdate 
} = require('../middleware/validation');

// Apply authentication to all routes
router.use(authenticateToken);

// Apply request size limiting to all routes
router.use(requestSizeLimiter);

// Create or update graduate details
router.post('/', 
    validateGraduateDetails,
    createOrUpdateGraduateDetails
);

// Get graduate details for current user
router.get('/', getGraduateDetails);

// Get graduate details by ID
router.get('/:id', getGraduateDetailsById);

// Update graduate details
router.put('/', 
    validateGraduateDetailsUpdate,
    updateGraduateDetails
);

// Delete graduate details
router.delete('/', deleteGraduateDetails);

// Get graduate completion status
router.get('/completion/status', getGraduateCompletion);

// Get colleges by pincode
router.get('/colleges/search', getColleges);

// Get schools by pincode
router.get('/schools/search', getSchools);

// Get all graduate details (Admin)
router.get('/admin/all', getAllGraduateDetails);

module.exports = router;
