const express = require('express');
const router = express.Router();
const examController = require('../controllers/examController');
const { authenticateToken } = require('../middleware/auth');
const { authenticateAdmin } = require('../middleware/adminAuth');

// Public Routes (with optional admin access)
router.get('/', examController.getAllExams);
router.get('/stage/:stage', examController.getExamsByStage);
router.get('/search', examController.searchExams);
router.get('/upcoming', examController.getUpcomingExams);
router.get('/categories', examController.getExamCategories);
router.get('/:examId', examController.getExamDetails);

// Admin Routes (Protected)
router.post('/', authenticateAdmin, examController.addExam);
router.put('/:examId', authenticateAdmin, examController.updateExam);
router.delete('/:examId', authenticateAdmin, examController.deleteExam);

module.exports = router;
