const express = require('express');
const router = express.Router();
const {
    searchCollegesByName,
    getCollegesByState,
    getCollegesByCity,
    getStates,
    getCities,
    getCollegeByAisheCode,
    getAllColleges
} = require('../controllers/collegeController');

// Public routes (no authentication required)

// Get all colleges (for dropdown with pagination and search)
router.get('/', (req, res, next) => {
    console.log(`🚀 [COLLEGE ROUTE DEBUG] ==========================================`);
    console.log(`🚀 [COLLEGE ROUTE DEBUG] Route: GET /api/colleges`);
    console.log(`🚀 [COLLEGE ROUTE DEBUG] Request URL: ${req.originalUrl}`);
    console.log(`🚀 [COLLEGE ROUTE DEBUG] Request method: ${req.method}`);
    console.log(`🚀 [COLLEGE ROUTE DEBUG] Request headers:`, req.headers);
    console.log(`🚀 [COLLEGE ROUTE DEBUG] Request query:`, req.query);
    console.log(`🚀 [COLLEGE ROUTE DEBUG] Request body:`, req.body);
    console.log(`🚀 [COLLEGE ROUTE DEBUG] Request params:`, req.params);
    console.log(`🚀 [COLLEGE ROUTE DEBUG] User agent: ${req.get('User-Agent')}`);
    console.log(`🚀 [COLLEGE ROUTE DEBUG] IP address: ${req.ip}`);
    console.log(`🚀 [COLLEGE ROUTE DEBUG] Timestamp: ${new Date().toISOString()}`);
    console.log(`🚀 [COLLEGE ROUTE DEBUG] ==========================================`);
    next();
}, getAllColleges);

// Search colleges by name
router.get('/search', searchCollegesByName);

// Get all states
router.get('/states', getStates);

// Get all cities
router.get('/cities', getCities);

// Get colleges by state
router.get('/state/:stateName', getCollegesByState);

// Get colleges by city
router.get('/city/:cityName', getCollegesByCity);

// Get college by AISHE code
router.get('/aishe/:aisheCode', getCollegeByAisheCode);

module.exports = router;