const express = require('express');
const router = express.Router();
const careerController = require('../controllers/careerController');
const { authenticateToken } = require('../middleware/auth');

// Career Goal Routes
router.post('/goal', authenticateToken, careerController.setCareerGoal);
router.get('/goal', authenticateToken, careerController.getCareerGoal);
router.put('/goal/progress', authenticateToken, careerController.updateCareerProgress);
router.get('/suggestions', authenticateToken, careerController.getCareerSuggestions);
router.get('/progress', authenticateToken, careerController.getCareerProgress);

// Career Path Routes (Public)
router.get('/paths/:stage', careerController.getCareerPaths);

module.exports = router;
