const express = require('express');
const router = express.Router();
const careerPathController = require('../controllers/careerPathController');
const { authenticateAdmin } = require('../middleware/adminAuth');

// Public Routes
router.get('/', careerPathController.getAllCareerPaths);
router.get('/:pathId', careerPathController.getCareerPathDetails);

// Admin Routes (Protected)
router.get('/admin', authenticateAdmin, careerPathController.getAllCareerPaths);
router.post('/', authenticateAdmin, careerPathController.addCareerPath);
router.put('/:pathId', authenticateAdmin, careerPathController.updateCareerPath);
router.delete('/:pathId', authenticateAdmin, careerPathController.deleteCareerPath);

module.exports = router;
