const express = require('express');
const router = express.Router();
const { 
    adminLogin, 
    getAdminProfile, 
    updateAdminProfile, 
    changePassword, 
    adminLogout 
} = require('../controllers/adminAuthController');
const { authenticateAdminToken, requireRole } = require('../middleware/adminAuth');

// Admin authentication routes
router.post('/login', 
    adminLogin
);

router.get('/profile', 
    authenticateAdminToken,
    getAdminProfile
);

router.put('/profile', 
    authenticateAdminToken,
    updateAdminProfile
);

router.put('/change-password', 
    authenticateAdminToken,
    changePassword
);

router.post('/logout', 
    authenticateAdminToken,
    adminLogout
);

// Test route to verify admin authentication
router.get('/verify', 
    authenticateAdminToken,
    (req, res) => {
        res.json({
            success: true,
            message: 'Admin token is valid',
            data: {
                admin: {
                    id: req.admin.id,
                    name: req.admin.name,
                    email: req.admin.email,
                    role: req.admin.role
                }
            }
        });
    }
);

module.exports = router;
