const mongoose = require('mongoose');

const redemptionSchema = new mongoose.Schema({
    user: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User',
        required: [true, 'User is required']
    },
    product: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Product',
        required: [true, 'Product is required']
    },
    coinsUsed: {
        type: Number,
        required: [true, 'Coins used is required'],
        min: [1, 'Coins used must be at least 1']
    },
    status: {
        type: String,
        enum: ['pending', 'processing', 'shipped', 'delivered', 'cancelled'],
        default: 'pending'
    },
    shippingAddress: {
        name: {
            type: String,
            required: [true, 'Shipping name is required'],
            trim: true,
            maxlength: [100, 'Name cannot exceed 100 characters']
        },
        phone: {
            type: String,
            required: [true, 'Phone number is required'],
            trim: true,
            maxlength: [15, 'Phone number cannot exceed 15 characters']
        },
        address: {
            type: String,
            required: [true, 'Address is required'],
            trim: true,
            maxlength: [200, 'Address cannot exceed 200 characters']
        },
        city: {
            type: String,
            required: [true, 'City is required'],
            trim: true,
            maxlength: [50, 'City cannot exceed 50 characters']
        },
        state: {
            type: String,
            required: [true, 'State is required'],
            trim: true,
            maxlength: [50, 'State cannot exceed 50 characters']
        },
        pincode: {
            type: String,
            required: [true, 'Pincode is required'],
            trim: true,
            maxlength: [10, 'Pincode cannot exceed 10 characters']
        }
    },
    trackingNumber: {
        type: String,
        trim: true,
        default: null
    },
    notes: {
        type: String,
        trim: true,
        maxlength: [500, 'Notes cannot exceed 500 characters']
    }
}, {
    timestamps: true
});

// Index for better query performance
redemptionSchema.index({ user: 1, status: 1 });
redemptionSchema.index({ status: 1 });

module.exports = mongoose.model('Redemption', redemptionSchema);
