const mongoose = require('mongoose');

const careerGoalSchema = new mongoose.Schema({
    userId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User',
        required: true
    },
    selectedPath: {
        type: String,
        required: true,
        enum: [
            // After 10th paths
            'science_11_12', 'commerce_11_12', 'arts_11_12', 'polytechnic',
            // After 12th Science
            'engineering', 'medical', 'pure_sciences', 'architecture', 'pharmacy',
            // After 12th Commerce
            'ca', 'banking', 'mba', 'bcom_jobs', 'company_secretary',
            // After 12th Arts
            'civil_services', 'journalism', 'teaching', 'law', 'social_work',
            // After Graduation
            'higher_studies', 'government_jobs', 'private_jobs', 'startup', 'freelancing'
        ]
    },
    currentStage: {
        type: String,
        required: true,
        enum: ['class_6_10', 'class_11_12', 'graduation', 'working_professional']
    },
    specificGoal: {
        type: String,
        required: true
    },
    targetYear: {
        type: Number,
        required: true
    },
    isCompleted: {
        type: Boolean,
        default: false
    },
    progressPercentage: {
        type: Number,
        default: 0,
        min: 0,
        max: 100
    }
}, {
    timestamps: true
});

module.exports = mongoose.model('CareerGoal', careerGoalSchema);
