# Backend Test Data Documentation

This document explains how to use the test data for user registration and login functionality in the backend.

## 🚀 Quick Start

### 1. Install Dependencies
```bash
npm install
```

### 2. Seed Test Data
```bash
npm run seed
```

### 3. Start the Server
```bash
npm run dev
```

### 4. Test the API
```bash
npm run test:api
```

## 📊 Test Users Data

The seeding script creates 7 test users with different verification states:

### ✅ Verified Users (Ready for Login)
| Name | Mobile | Password | DOB |
|------|--------|----------|-----|
| John Doe | +1234567890 | password123 | 1990-05-15 |
| Jane Smith | +1234567891 | password456 | 1985-12-20 |
| David Brown | +1234567894 | password202 | 1995-11-30 |
| Admin User | +1111111111 | admin123 | 1980-01-01 |

### ❌ Unverified Users (Need OTP Verification)
| Name | Mobile | Password | OTP | DOB |
|------|--------|----------|-----|-----|
| Mike Johnson | +1234567892 | password789 | 123456 | 1992-08-10 |
| Sarah Wilson | +1234567893 | password101 | 654321 | 1988-03-25 |
| Emily Davis | +1234567895 | password303 | 111111 | 1993-07-14 |

## 🔗 API Endpoints

### Authentication Endpoints
- `POST /api/auth/login` - Login with mobile and password
- `GET /api/auth/profile/:userId` - Get user profile by ID

### User Management Endpoints
- `POST /api/users/register` - Register new user
- `POST /api/users/verify-otp` - Verify OTP for registration
- `POST /api/users/resend-otp` - Resend OTP
- `GET /api/users/all` - Get all users (for testing)
- `GET /api/users/mobile/:mobile` - Get user by mobile number

### Health Check
- `GET /health` - Check server and database status

## 🧪 Testing Examples

### 1. Login with Verified User
```bash
curl -X POST http://localhost:5000/api/auth/login \
  -H "Content-Type: application/json" \
  -d '{
    "mobile": "+1234567890",
    "password": "password123"
  }'
```

### 2. Register New User
```bash
curl -X POST http://localhost:5000/api/users/register \
  -H "Content-Type: application/json" \
  -d '{
    "name": "Test User",
    "dob": "1995-01-01",
    "mobile": "+9999999999",
    "password": "testpassword123"
  }'
```

### 3. Verify OTP
```bash
curl -X POST http://localhost:5000/api/users/verify-otp \
  -H "Content-Type: application/json" \
  -d '{
    "mobile": "+1234567892",
    "otp": "123456"
  }'
```

### 4. Get All Users
```bash
curl http://localhost:5000/api/users/all
```

## 📝 Response Formats

### Successful Login Response
```json
{
  "success": true,
  "message": "Login successful",
  "data": {
    "user": {
      "id": "user_id",
      "name": "John Doe",
      "mobile": "+1234567890",
      "dob": "1990-05-15T00:00:00.000Z"
    },
    "token": "jwt_token_here"
  }
}
```

### Registration Response
```json
{
  "success": true,
  "message": "Registration successful. Please verify OTP.",
  "data": {
    "userId": "user_id",
    "name": "Test User",
    "mobile": "+9999999999"
  }
}
```

### Error Response
```json
{
  "success": false,
  "message": "Error message here",
  "error": "Detailed error information"
}
```

## 🔧 Scripts Available

- `npm run seed` - Seed the database with test users
- `npm run seed:users` - Same as above (alias)
- `npm run test:api` - Run API tests (requires server to be running)
- `npm run test` - Seed database and run API tests
- `npm run dev` - Start development server with nodemon
- `npm start` - Start production server

## 🗄️ Database Information

- **Database**: recon_db
- **Collection**: users
- **Connection**: MongoDB at 135.181.103.182:1200

## 🔐 Security Notes

- Passwords are hashed using SHA-256
- JWT tokens expire after 24 hours
- OTP codes expire after 10 minutes
- Passwords and OTP codes are excluded from user profile responses

## 🐛 Troubleshooting

### Database Connection Issues
1. Check if MongoDB server is running
2. Verify network connectivity to 135.181.103.182:1200
3. Check firewall settings

### API Testing Issues
1. Ensure server is running on port 5000
2. Install axios: `npm install axios`
3. Check server logs for errors

### OTP Verification Issues
1. Check if OTP has expired (10 minutes)
2. Verify the mobile number is correct
3. Use the correct OTP from console logs or database

## 📱 Mobile Number Format

All test users use the format: `+123456789X` where X is a digit.

For testing, you can use any valid mobile number format, but the test data uses this consistent format.

## 🔄 Data Reset

To reset the test data:
```bash
npm run seed
```

This will:
1. Clear all existing users
2. Create fresh test users
3. Display all created users with their credentials
