const mongoose = require('mongoose');
const User = require('../models/User');

// Connect to database
const connectDB = require('../utils/db');
connectDB();

async function updateProfessionStatus() {
    try {
        console.log('🔄 [UPDATE] Updating profession status for testing...\n');
        
        // Find a user to update
        const user = await User.findOne().select('_id name mobile profession_status');
        
        if (!user) {
            console.log('❌ [UPDATE] No users found in database');
            return;
        }
        
        console.log(`📝 [UPDATE] Found user: ${user.name} (${user.mobile})`);
        console.log(`📝 [UPDATE] Current profession_status: ${user.profession_status}`);
        
        // Update profession_status to true
        user.profession_status = true;
        await user.save();
        
        console.log(`✅ [UPDATE] Updated profession_status to: ${user.profession_status}`);
        console.log(`✅ [UPDATE] User ID: ${user._id}`);
        console.log(`\n🧪 [TEST] You can now test the API with this user ID: ${user._id}`);
        
        // Test the API endpoint
        console.log(`\n🔗 [TEST] Test URL: http://localhost:5500/api/users/profession-status/${user._id}`);
        
    } catch (error) {
        console.error('❌ [UPDATE ERROR] Failed to update profession status:', error);
    } finally {
        // Close database connection
        mongoose.connection.close();
    }
}

// Run the update
updateProfessionStatus();
