const axios = require('axios');

const BASE_URL = 'http://localhost:5500/api';
const authToken = 'YOUR_JWT_TOKEN_HERE'; // Replace with actual JWT token

const headers = {
    'Authorization': `Bearer ${authToken}`,
    'Content-Type': 'application/json'
};

async function testUserRoutes() {
    console.log('👤 Testing User Routes\n');
    
    try {
        // Test 1: Get current user information
        console.log('📋 Test 1: Get current user information');
        console.log('GET /api/users');
        const response1 = await axios.get(`${BASE_URL}/users`, { headers });
        console.log('✅ Status:', response1.status);
        console.log('📊 Response:', JSON.stringify(response1.data, null, 2));
        console.log('---\n');
        
        // Test 2: Get current user's occupation status
        console.log('📋 Test 2: Get current user occupation status');
        console.log('GET /api/users/occupation-status');
        const response2 = await axios.get(`${BASE_URL}/users/occupation-status`, { headers });
        console.log('✅ Status:', response2.status);
        console.log('📊 Response:', JSON.stringify(response2.data, null, 2));
        console.log('---\n');
        
        // Test 3: Get all users (existing route)
        console.log('📋 Test 3: Get all users');
        console.log('GET /api/users/all');
        const response3 = await axios.get(`${BASE_URL}/users/all`, { headers });
        console.log('✅ Status:', response3.status);
        console.log('📊 Response:', JSON.stringify(response3.data, null, 2));
        console.log('---\n');
        
        // Test 4: Get user completion status
        console.log('📋 Test 4: Get user completion status');
        console.log('GET /api/users/completion-status');
        const response4 = await axios.get(`${BASE_URL}/users/completion-status`, { headers });
        console.log('✅ Status:', response4.status);
        console.log('📊 Response:', JSON.stringify(response4.data, null, 2));
        console.log('---\n');
        
        // Test 5: Get occupation details
        console.log('📋 Test 5: Get occupation details');
        console.log('GET /api/users/occupation');
        const response5 = await axios.get(`${BASE_URL}/users/occupation`, { headers });
        console.log('✅ Status:', response5.status);
        console.log('📊 Response:', JSON.stringify(response5.data, null, 2));
        console.log('---\n');
        
    } catch (error) {
        console.error('❌ Test failed:', error.response?.data || error.message);
        console.error('❌ Full error:', error);
        
        if (error.response?.status === 404) {
            console.log('\n💡 The route might not be found. Please check:');
            console.log('1. Server is running on the correct port');
            console.log('2. Authentication token is valid');
            console.log('3. Route is properly defined in userRoutes.js');
        }
    }
}

// Run the test
testUserRoutes();
