const axios = require('axios');

const BASE_URL = 'http://localhost:5500';

async function testUserRegistration() {
    console.log('🧪 [TEST] Testing User Registration with Date Validation...\n');
    
    const testCases = [
        {
            name: 'Valid Registration with DOB (YYYY-MM-DD)',
            data: {
                name: 'Test User',
                mobile: '9876543210',
                password: 'password123',
                dob: '1990-05-15'
            },
            expected: 'success'
        },
        {
            name: 'Valid Registration with DOB (DD-MM-YYYY)',
            data: {
                name: 'Test User DD-MM',
                mobile: '9876543215',
                password: 'password123',
                dob: '15-05-1990'
            },
            expected: 'success'
        },
        {
            name: 'Valid Registration with DOB (MM/DD/YYYY)',
            data: {
                name: 'Test User MM/DD',
                mobile: '9876543216',
                password: 'password123',
                dob: '05/15/1990'
            },
            expected: 'success'
        },
        {
            name: 'Valid Registration without DOB',
            data: {
                name: 'Test User 2',
                mobile: '9876543211',
                password: 'password123'
            },
            expected: 'success'
        },
        {
            name: 'Invalid DOB Format',
            data: {
                name: 'Test User 3',
                mobile: '9876543212',
                password: 'password123',
                dob: 'invalid-date'
            },
            expected: 'error'
        },
        {
            name: 'Future DOB',
            data: {
                name: 'Test User 4',
                mobile: '9876543213',
                password: 'password123',
                dob: '2030-01-01'
            },
            expected: 'error'
        },
        {
            name: 'Empty DOB String',
            data: {
                name: 'Test User 5',
                mobile: '9876543214',
                password: 'password123',
                dob: ''
            },
            expected: 'success'
        }
    ];
    
    for (const testCase of testCases) {
        try {
            console.log(`📝 [TEST] ${testCase.name}...`);
            console.log(`📝 [TEST] Data:`, testCase.data);
            
            const response = await axios.post(`${BASE_URL}/api/auth/register`, testCase.data);
            
            if (testCase.expected === 'success') {
                console.log(`✅ [TEST] ${testCase.name} - SUCCESS`);
                console.log(`✅ [TEST] Response:`, response.data);
            } else {
                console.log(`❌ [TEST] ${testCase.name} - UNEXPECTED SUCCESS (expected error)`);
            }
            
        } catch (error) {
            if (testCase.expected === 'error') {
                console.log(`✅ [TEST] ${testCase.name} - EXPECTED ERROR`);
                console.log(`✅ [TEST] Error:`, error.response?.data?.message || error.message);
            } else {
                console.log(`❌ [TEST] ${testCase.name} - UNEXPECTED ERROR`);
                console.log(`❌ [TEST] Error:`, error.response?.data || error.message);
            }
        }
        
        console.log('---\n');
    }
    
    console.log('🎉 [TEST] User registration tests completed!');
}

// Run the test
testUserRegistration().catch(console.error);
