const axios = require('axios');

const BASE_URL = 'http://192.168.29.136:5500/api/users';
const TEST_USER_ID = '68d2b0eb2a0740535e9c35c4'; // Replace with actual user ID
const AUTH_TOKEN = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6IjY4ZDJiMGViMmEwNzQwNTM1ZTljMzVjNCIsImlhdCI6MTczNzU0NzQ4MCwiZXhwIjoxNzM4MTUyMjgwfQ.8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ'; // Replace with actual token

async function testUserAboutAPI() {
    console.log('🧪 Testing User About API...\n');
    
    try {
        // Test 1: Get user about
        console.log('📝 Test 1: Get user about');
        const getAboutResponse = await axios.get(`${BASE_URL}/about/${TEST_USER_ID}`);
        console.log('✅ Get About Response:', getAboutResponse.data);
        console.log('');
        
        // Test 2: Update user about
        console.log('📝 Test 2: Update user about');
        const updateAboutResponse = await axios.put(`${BASE_URL}/about/${TEST_USER_ID}`, {
            about: 'This is a test about section for the user. I am testing the about functionality.'
        }, {
            headers: {
                'Authorization': `Bearer ${AUTH_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ Update About Response:', updateAboutResponse.data);
        console.log('');
        
        // Test 3: Get updated about
        console.log('📝 Test 3: Get updated about');
        const getUpdatedAboutResponse = await axios.get(`${BASE_URL}/about/${TEST_USER_ID}`);
        console.log('✅ Get Updated About Response:', getUpdatedAboutResponse.data);
        console.log('');
        
    } catch (error) {
        console.error('❌ About API Test Failed:', error.response?.data || error.message);
    }
}

async function testUserInterestsAPI() {
    console.log('🧪 Testing User Interests API...\n');
    
    try {
        // Test 1: Get user interests
        console.log('🎯 Test 1: Get user interests');
        const getInterestsResponse = await axios.get(`${BASE_URL}/interests/${TEST_USER_ID}`);
        console.log('✅ Get Interests Response:', getInterestsResponse.data);
        console.log('');
        
        // Test 2: Update user interests
        console.log('🎯 Test 2: Update user interests');
        const updateInterestsResponse = await axios.put(`${BASE_URL}/interests/${TEST_USER_ID}`, {
            interests: ['Technology', 'Programming', 'Web Development', 'Mobile Apps', 'AI/ML']
        }, {
            headers: {
                'Authorization': `Bearer ${AUTH_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ Update Interests Response:', updateInterestsResponse.data);
        console.log('');
        
        // Test 3: Get updated interests
        console.log('🎯 Test 3: Get updated interests');
        const getUpdatedInterestsResponse = await axios.get(`${BASE_URL}/interests/${TEST_USER_ID}`);
        console.log('✅ Get Updated Interests Response:', getUpdatedInterestsResponse.data);
        console.log('');
        
        // Test 4: Update with empty interests
        console.log('🎯 Test 4: Update with empty interests');
        const updateEmptyInterestsResponse = await axios.put(`${BASE_URL}/interests/${TEST_USER_ID}`, {
            interests: []
        }, {
            headers: {
                'Authorization': `Bearer ${AUTH_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ Update Empty Interests Response:', updateEmptyInterestsResponse.data);
        console.log('');
        
    } catch (error) {
        console.error('❌ Interests API Test Failed:', error.response?.data || error.message);
    }
}

async function testValidationErrors() {
    console.log('🧪 Testing Validation Errors...\n');
    
    try {
        // Test 1: Invalid about type
        console.log('📝 Test 1: Invalid about type (number instead of string)');
        try {
            await axios.put(`${BASE_URL}/about/${TEST_USER_ID}`, {
                about: 12345
            }, {
                headers: {
                    'Authorization': `Bearer ${AUTH_TOKEN}`,
                    'Content-Type': 'application/json'
                }
            });
        } catch (error) {
            console.log('✅ Expected validation error:', error.response?.data);
        }
        console.log('');
        
        // Test 2: About too long
        console.log('📝 Test 2: About too long (>1000 characters)');
        try {
            await axios.put(`${BASE_URL}/about/${TEST_USER_ID}`, {
                about: 'A'.repeat(1001)
            }, {
                headers: {
                    'Authorization': `Bearer ${AUTH_TOKEN}`,
                    'Content-Type': 'application/json'
                }
            });
        } catch (error) {
            console.log('✅ Expected validation error:', error.response?.data);
        }
        console.log('');
        
        // Test 3: Invalid interests type
        console.log('🎯 Test 3: Invalid interests type (string instead of array)');
        try {
            await axios.put(`${BASE_URL}/interests/${TEST_USER_ID}`, {
                interests: 'Technology'
            }, {
                headers: {
                    'Authorization': `Bearer ${AUTH_TOKEN}`,
                    'Content-Type': 'application/json'
                }
            });
        } catch (error) {
            console.log('✅ Expected validation error:', error.response?.data);
        }
        console.log('');
        
        // Test 4: Interest too long
        console.log('🎯 Test 4: Interest too long (>100 characters)');
        try {
            await axios.put(`${BASE_URL}/interests/${TEST_USER_ID}`, {
                interests: ['A'.repeat(101)]
            }, {
                headers: {
                    'Authorization': `Bearer ${AUTH_TOKEN}`,
                    'Content-Type': 'application/json'
                }
            });
        } catch (error) {
            console.log('✅ Expected validation error:', error.response?.data);
        }
        console.log('');
        
    } catch (error) {
        console.error('❌ Validation Test Failed:', error.response?.data || error.message);
    }
}

async function runAllTests() {
    console.log('🚀 Starting User About and Interests API Tests...\n');
    console.log('='.repeat(60));
    
    await testUserAboutAPI();
    console.log('='.repeat(60));
    
    await testUserInterestsAPI();
    console.log('='.repeat(60));
    
    await testValidationErrors();
    console.log('='.repeat(60));
    
    console.log('✅ All tests completed!');
}

// Run the tests
runAllTests().catch(console.error);
