const axios = require('axios');

const BASE_URL = 'http://localhost:5500';
const TEST_TOKEN = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6IjY4YzdlZjQxM2M4NjQ3N2IzYjYyNjE3MiIsIm1vYmlsZSI6Ijk1MTU0NDYwODAiLCJpYXQiOjE3NTg2MDkxOTIsImV4cCI6MTc1ODY5NTU5Mn0.3kmZLm2-Jo8gjmBf4L1w7_KG7S_TXpf7vHCln_aKZlM'; // Replace with your actual token
const TEST_USER_ID = '68c7ef413c86477b3b626172'; // Replace with your actual user ID

async function testSchoolDetailsAPI() {
    console.log('🧪 [TEST] Testing School Details API...\n');
    
    try {
        // Test 1: Get school details (should return null initially)
        console.log('📝 [TEST 1] Getting school details...');
        const getResponse = await axios.get(`${BASE_URL}/api/users/school-details/${TEST_USER_ID}`);
        
        console.log('✅ [TEST 1] Get school details response:');
        console.log(JSON.stringify(getResponse.data, null, 2));
        
        // Test 2: Update school details
        console.log('\n📝 [TEST 2] Updating school details...');
        const updateData = {
            schoolState: 'Andhra Pradesh',
            schoolDistrict: 'Visakhapatnam',
            schoolVillage: 'Madhurawada',
            schoolCode: '28110901201',
            schoolName: 'GOVT HIGH SCHOOL MADHURAWADA',
            class10thStatus: 'completed',
            academicYear: '2023-24'
        };
        
        const updateResponse = await axios.put(`${BASE_URL}/api/users/school-details/${TEST_USER_ID}`, updateData, {
            headers: {
                'Authorization': `Bearer ${TEST_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        
        console.log('✅ [TEST 2] Update school details response:');
        console.log(JSON.stringify(updateResponse.data, null, 2));
        
        // Test 3: Get school details again (should now have data)
        console.log('\n📝 [TEST 3] Getting updated school details...');
        const getUpdatedResponse = await axios.get(`${BASE_URL}/api/users/school-details/${TEST_USER_ID}`);
        
        console.log('✅ [TEST 3] Get updated school details response:');
        console.log(JSON.stringify(getUpdatedResponse.data, null, 2));
        
        // Test 4: Partial update
        console.log('\n📝 [TEST 4] Partial update (only class10thStatus)...');
        const partialUpdateData = {
            class10thStatus: 'ongoing',
            academicYear: '2024-25'
        };
        
        const partialUpdateResponse = await axios.put(`${BASE_URL}/api/users/school-details/${TEST_USER_ID}`, partialUpdateData, {
            headers: {
                'Authorization': `Bearer ${TEST_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        
        console.log('✅ [TEST 4] Partial update response:');
        console.log(JSON.stringify(partialUpdateResponse.data, null, 2));
        
        // Test 5: Test with invalid user ID
        console.log('\n📝 [TEST 5] Testing with invalid user ID...');
        try {
            await axios.get(`${BASE_URL}/api/users/school-details/invalid_user_id`);
        } catch (error) {
            console.log('✅ [TEST 5] Expected error for invalid user ID:');
            console.log(JSON.stringify(error.response?.data, null, 2));
        }
        
    } catch (error) {
        console.error('❌ [TEST ERROR] Test failed:', {
            message: error.message,
            status: error.response?.status,
            statusText: error.response?.statusText,
            data: error.response?.data
        });
    }
    
    console.log('\n🎉 [TEST] School details API tests completed!');
}

// Run the test
testSchoolDetailsAPI().catch(console.error);
