const mongoose = require('mongoose');
const User = require('../models/User');
const crypto = require('crypto');

// Test profile image functionality
const testProfileImage = async () => {
    try {
        // Connect to database
        await mongoose.connect(process.env.MONGODB_URI || 'mongodb://localhost:27017/reconnectifly');
        console.log('Connected to database');

        // Create a test user
        const testUser = new User({
            name: 'Test User',
            dob: new Date('1990-01-01'),
            mobile: '1234567890',
            password: 'testpassword123',
            isVerified: true
        });

        await testUser.save();
        console.log('Test user created:', testUser._id);

        // Test base64 image (1x1 pixel PNG)
        const testImage = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mNkYPhfDwAChwGA60e6kgAAAABJRU5ErkJggg==';

        // Test uploading profile image
        testUser.profileImage = testImage;
        await testUser.save();
        console.log('Profile image uploaded successfully');

        // Test retrieving profile image
        const savedUser = await User.findById(testUser._id).select('profileImage');
        console.log('Profile image retrieved:', savedUser.profileImage ? 'Yes' : 'No');
        console.log('Has profile image:', !!savedUser.profileImage);

        // Test deleting profile image
        testUser.profileImage = null;
        await testUser.save();
        console.log('Profile image deleted successfully');

        // Verify deletion
        const userAfterDeletion = await User.findById(testUser._id).select('profileImage');
        console.log('Profile image after deletion:', userAfterDeletion.profileImage);

        // Clean up test user
        await User.findByIdAndDelete(testUser._id);
        console.log('Test user deleted');

        console.log('✅ All profile image tests passed!');

    } catch (error) {
        console.error('❌ Test failed:', error);
    } finally {
        await mongoose.disconnect();
        console.log('Disconnected from database');
    }
};

// Run the test
testProfileImage();
