const axios = require('axios');

const BASE_URL = 'http://192.168.29.136:5500/api/users';
const AUTH_TOKEN = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6IjY4ZDJiMGViMmEwNzQwNTM1ZTljMzVjNCIsImlhdCI6MTczNzU0NzQ4MCwiZXhwIjoxNzM4MTUyMjgwfQ.8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ'; // Replace with actual token

async function testCreateOccupation() {
    console.log('🧪 Testing Create/Update Occupation...\n');
    
    try {
        // Test 1: Create occupation details
        console.log('💼 Test 1: Create occupation details');
        const occupationData = {
            occupation: 'graduate student'
        };
        
        const createResponse = await axios.post(`${BASE_URL}/occupation`, occupationData, {
            headers: {
                'Authorization': `Bearer ${AUTH_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ Create Occupation Response:', createResponse.data);
        console.log('');
        
        return createResponse.data;
        
    } catch (error) {
        console.error('❌ Create Occupation Test Failed:', error.response?.data || error.message);
        return null;
    }
}

async function testGetOccupation() {
    console.log('🧪 Testing Get Occupation...\n');
    
    try {
        // Test 1: Get occupation details
        console.log('💼 Test 1: Get occupation details');
        const getResponse = await axios.get(`${BASE_URL}/occupation`, {
            headers: {
                'Authorization': `Bearer ${AUTH_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ Get Occupation Response:', getResponse.data);
        console.log('');
        
        return getResponse.data;
        
    } catch (error) {
        console.error('❌ Get Occupation Test Failed:', error.response?.data || error.message);
        return null;
    }
}

async function testUpdateOccupation() {
    console.log('🧪 Testing Update Occupation...\n');
    
    try {
        // Test 1: Update occupation details
        console.log('💼 Test 1: Update occupation details');
        const updateData = {
            occupation: 'working professional'
        };
        
        const updateResponse = await axios.post(`${BASE_URL}/occupation`, updateData, {
            headers: {
                'Authorization': `Bearer ${AUTH_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ Update Occupation Response:', updateResponse.data);
        console.log('');
        
        return updateResponse.data;
        
    } catch (error) {
        console.error('❌ Update Occupation Test Failed:', error.response?.data || error.message);
        return null;
    }
}

async function testDeleteOccupation() {
    console.log('🧪 Testing Delete Occupation...\n');
    
    try {
        // Test 1: Delete occupation details
        console.log('💼 Test 1: Delete occupation details');
        const deleteResponse = await axios.delete(`${BASE_URL}/occupation`, {
            headers: {
                'Authorization': `Bearer ${AUTH_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ Delete Occupation Response:', deleteResponse.data);
        console.log('');
        
        return deleteResponse.data;
        
    } catch (error) {
        console.error('❌ Delete Occupation Test Failed:', error.response?.data || error.message);
        return null;
    }
}

async function testValidationErrors() {
    console.log('🧪 Testing Occupation Validation Errors...\n');
    
    try {
        // Test 1: Missing required fields
        console.log('💼 Test 1: Missing required fields');
        try {
            await axios.post(`${BASE_URL}/occupation`, {
                // Missing occupation field
            }, {
                headers: {
                    'Authorization': `Bearer ${AUTH_TOKEN}`,
                    'Content-Type': 'application/json'
                }
            });
        } catch (error) {
            console.log('✅ Expected validation error:', error.response?.data);
        }
        console.log('');
        
        // Test 2: Invalid occupation value
        console.log('💼 Test 2: Invalid occupation value');
        try {
            await axios.post(`${BASE_URL}/occupation`, {
                occupation: 'invalid occupation'
            }, {
                headers: {
                    'Authorization': `Bearer ${AUTH_TOKEN}`,
                    'Content-Type': 'application/json'
                }
            });
        } catch (error) {
            console.log('✅ Expected validation error:', error.response?.data);
        }
        console.log('');
        
    } catch (error) {
        console.error('❌ Validation Test Failed:', error.response?.data || error.message);
    }
}

async function testCompletionStatus() {
    console.log('🧪 Testing Completion Status Updates...\n');
    
    try {
        // Test 1: Create occupation and check completion status
        console.log('💼 Test 1: Create occupation and check completion status');
        const occupationData = {
            occupation: 'business'
        };
        
        const createResponse = await axios.post(`${BASE_URL}/occupation`, occupationData, {
            headers: {
                'Authorization': `Bearer ${AUTH_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        
        console.log('✅ Occupation Created - Completion Status:');
        console.log(`   - occupationCompleted: ${createResponse.data.data.occupationCompleted}`);
        console.log(`   - personalDetailsCompleted: ${createResponse.data.data.personalDetailsCompleted}`);
        console.log(`   - hasOccupation: ${createResponse.data.data.hasOccupation}`);
        console.log(`   - hasPersonalDetails: ${createResponse.data.data.hasPersonalDetails}`);
        console.log('');
        
        // Test 2: Delete occupation and check completion status
        console.log('💼 Test 2: Delete occupation and check completion status');
        const deleteResponse = await axios.delete(`${BASE_URL}/occupation`, {
            headers: {
                'Authorization': `Bearer ${AUTH_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        
        console.log('✅ Occupation Deleted - Completion Status:');
        console.log(`   - occupationCompleted: ${deleteResponse.data.data.occupationCompleted}`);
        console.log(`   - personalDetailsCompleted: ${deleteResponse.data.data.personalDetailsCompleted}`);
        console.log(`   - hasOccupation: ${deleteResponse.data.data.hasOccupation}`);
        console.log(`   - hasPersonalDetails: ${deleteResponse.data.data.hasPersonalDetails}`);
        console.log('');
        
    } catch (error) {
        console.error('❌ Completion Status Test Failed:', error.response?.data || error.message);
    }
}

async function runAllTests() {
    console.log('🚀 Starting Occupation API Tests...\n');
    console.log('='.repeat(60));
    
    await testCreateOccupation();
    console.log('='.repeat(60));
    
    await testGetOccupation();
    console.log('='.repeat(60));
    
    await testUpdateOccupation();
    console.log('='.repeat(60));
    
    await testValidationErrors();
    console.log('='.repeat(60));
    
    await testCompletionStatus();
    console.log('='.repeat(60));
    
    await testDeleteOccupation();
    console.log('='.repeat(60));
    
    console.log('✅ All occupation tests completed!');
}

// Run the tests
runAllTests().catch(console.error);
