const newsService = require('../services/newsService');

const testNewsFetch = async () => {
    try {
        console.log('🚀 Testing news fetch...');
        
        // Test fetching from NewsAPI
        console.log('📰 Fetching from NewsAPI...');
        const newsApiArticles = await newsService.fetchFromNewsAPI('technology', 5);
        console.log(`✅ NewsAPI returned ${newsApiArticles.length} articles`);
        
        if (newsApiArticles.length > 0) {
            console.log('📄 Sample article:', {
                title: newsApiArticles[0].title,
                source: newsApiArticles[0].source,
                category: newsApiArticles[0].category,
                url: newsApiArticles[0].url
            });
        }
        
        // Test saving articles
        console.log('💾 Testing article saving...');
        const { savedArticles, errors } = await newsService.saveArticles(newsApiArticles);
        console.log(`✅ Saved ${savedArticles.length} articles, ${errors.length} errors`);
        
        if (errors.length > 0) {
            console.log('❌ Errors:', errors);
        }
        
    } catch (error) {
        console.error('❌ Test failed:', error.message);
        console.error('Stack:', error.stack);
    }
};

testNewsFetch();
