const axios = require('axios');

const testNewsAPI = async () => {
    try {
        console.log('🧪 Testing NewsAPI...');
        const apiKey = '4a039be72844448a9adcd837fb920bbc';
        const response = await axios.get('https://newsapi.org/v2/everything', {
            params: {
                q: 'technology',
                apiKey: apiKey,
                pageSize: 5,
                sortBy: 'publishedAt',
                language: 'en'
            },
            timeout: 30000
        });
        
        console.log('✅ NewsAPI Status:', response.data.status);
        console.log('📊 Articles found:', response.data.articles?.length || 0);
        
        if (response.data.articles && response.data.articles.length > 0) {
            console.log('📰 Sample article:', {
                title: response.data.articles[0].title,
                source: response.data.articles[0].source?.name,
                publishedAt: response.data.articles[0].publishedAt
            });
        }
        
    } catch (error) {
        console.error('❌ NewsAPI Error:', error.response?.data || error.message);
    }
};

const testCurrentsAPI = async () => {
    try {
        console.log('🧪 Testing Currents API...');
        const apiKey = 'OwUf8-lpvINu6cfU20IfxPNxlEO9oYYZnch-3l-k6afTJ0Xu';
        const response = await axios.get('https://api.currentsapi.services/v1/search', {
            params: {
                apiKey: apiKey,
                keywords: 'technology',
                language: 'en',
                limit: 5
            },
            timeout: 30000
        });
        
        console.log('✅ Currents API Status:', response.data.status);
        console.log('📊 Articles found:', response.data.news?.length || 0);
        
        if (response.data.news && response.data.news.length > 0) {
            console.log('📰 Sample article:', {
                title: response.data.news[0].title,
                author: response.data.news[0].author,
                published: response.data.news[0].published
            });
        }
        
    } catch (error) {
        console.error('❌ Currents API Error:', error.response?.data || error.message);
    }
};

const runTests = async () => {
    console.log('🚀 Testing External News APIs...\n');
    
    await testNewsAPI();
    console.log('');
    
    await testCurrentsAPI();
    console.log('');
    
    console.log('🎉 API tests completed!');
};

runTests().catch(console.error);
