const axios = require('axios');

const BASE_URL = 'http://192.168.29.136:5500/api/users';
const AUTH_TOKEN = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6IjY4ZDJiMGViMmEwNzQwNTM1ZTljMzVjNCIsImlhdCI6MTczNzU0NzQ4MCwiZXhwIjoxNzM4MTUyMjgwfQ.8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ8QZ'; // Replace with actual token

async function testSchoolDetailsUpdate() {
    console.log('🧪 Testing School Details Update (Group Creation)...\n');
    
    try {
        // Test 1: Update school details
        console.log('🏫 Test 1: Update school details');
        const schoolData = {
            schoolState: 'Delhi',
            schoolDistrict: 'New Delhi',
            schoolVillage: 'Delhi',
            schoolCode: 'TEST_SCHOOL_001',
            schoolName: 'Test School',
            class10thStatus: 'Completed',
            academicYear: '2020-2021'
        };
        
        const schoolResponse = await axios.put(`${BASE_URL}/school-details/68d2b0eb2a0740535e9c35c4`, schoolData, {
            headers: {
                'Authorization': `Bearer ${AUTH_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ School Details Update Response:', schoolResponse.data);
        console.log('');
        
        return schoolResponse.data;
        
    } catch (error) {
        console.error('❌ School Details Update Test Failed:', error.response?.data || error.message);
        return null;
    }
}

async function testCollegeDetailsUpdate() {
    console.log('🧪 Testing College Details Update (Group Creation)...\n');
    
    try {
        // Test 1: Update college details
        console.log('🎓 Test 1: Update college details');
        const collegeData = {
            graduationStatus: 'Completed',
            collegeCode: 'TEST_COLLEGE_001',
            collegeName: 'Test College',
            courseName: 'Computer Science',
            courseSubBranch: 'Software Engineering',
            academicYear: '2020-2024',
            selectOnYear: '2020'
        };
        
        const collegeResponse = await axios.put(`${BASE_URL}/college-details/68d2b0eb2a0740535e9c35c4`, collegeData, {
            headers: {
                'Authorization': `Bearer ${AUTH_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ College Details Update Response:', collegeResponse.data);
        console.log('');
        
        return collegeResponse.data;
        
    } catch (error) {
        console.error('❌ College Details Update Test Failed:', error.response?.data || error.message);
        return null;
    }
}

async function testGroupDetails() {
    console.log('🧪 Testing Group Details (Check Members Array)...\n');
    
    try {
        // Test 1: Get school group details
        console.log('🏫 Test 1: Get school group details');
        const schoolGroupResponse = await axios.get(`${BASE_URL}/groups/school/TEST_SCHOOL_001_2020-2021`, {
            headers: {
                'Authorization': `Bearer ${AUTH_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ School Group Response:', schoolGroupResponse.data);
        console.log(`   - Member Count: ${schoolGroupResponse.data.data.group.memberCount}`);
        console.log(`   - Members Array Length: ${schoolGroupResponse.data.data.group.membersCount}`);
        console.log(`   - Members: ${JSON.stringify(schoolGroupResponse.data.data.group.members)}`);
        console.log('');
        
        // Test 2: Get college group details
        console.log('🎓 Test 2: Get college group details');
        const collegeGroupResponse = await axios.get(`${BASE_URL}/groups/college/TEST_COLLEGE_001_2020-2024_Computer Science_Software Engineering`, {
            headers: {
                'Authorization': `Bearer ${AUTH_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ College Group Response:', collegeGroupResponse.data);
        console.log(`   - Member Count: ${collegeGroupResponse.data.data.group.memberCount}`);
        console.log(`   - Members Array Length: ${collegeGroupResponse.data.data.group.membersCount}`);
        console.log(`   - Members: ${JSON.stringify(collegeGroupResponse.data.data.group.members)}`);
        console.log('');
        
    } catch (error) {
        console.error('❌ Group Details Test Failed:', error.response?.data || error.message);
    }
}

async function testUserGroups() {
    console.log('🧪 Testing User Groups (Check if user is in groups)...\n');
    
    try {
        // Test 1: Get user groups
        console.log('👥 Test 1: Get user groups');
        const userGroupsResponse = await axios.get(`${BASE_URL}/groups/user/68d2b0eb2a0740535e9c35c4`, {
            headers: {
                'Authorization': `Bearer ${AUTH_TOKEN}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ User Groups Response:', userGroupsResponse.data);
        console.log('');
        
        // Check if user is a member of any groups
        const groups = userGroupsResponse.data.data.groups;
        groups.forEach((group, index) => {
            console.log(`Group ${index + 1}:`);
            console.log(`   - Group ID: ${group.groupId}`);
            console.log(`   - Group Type: ${group.groupType}`);
            console.log(`   - Is User Member: ${group.isUserMember}`);
            console.log(`   - Member Count: ${group.memberCount}`);
            console.log(`   - Members Count: ${group.membersCount}`);
            console.log('');
        });
        
    } catch (error) {
        console.error('❌ User Groups Test Failed:', error.response?.data || error.message);
    }
}

async function runAllTests() {
    console.log('🚀 Starting Group Creation Without Members Tests...\n');
    console.log('='.repeat(60));
    
    await testSchoolDetailsUpdate();
    console.log('='.repeat(60));
    
    await testCollegeDetailsUpdate();
    console.log('='.repeat(60));
    
    await testGroupDetails();
    console.log('='.repeat(60));
    
    await testUserGroups();
    console.log('='.repeat(60));
    
    console.log('✅ All tests completed!');
    console.log('📝 Expected Results:');
    console.log('   - Groups should be created successfully');
    console.log('   - Member count should be 0');
    console.log('   - Members array should be empty');
    console.log('   - User should NOT be automatically added as member');
}

// Run the tests
runAllTests().catch(console.error);
