const axios = require('axios');

const BASE_URL = 'http://localhost:5500/api';

// Test data - Replace with actual IDs from your database
const testUserId = '68c7ef413c86477b3b626172'; // Replace with actual user ID
const testGroupId = '68d2a1ec52d4291170859da5'; // Replace with actual group ID

async function testDemoJoinGroup() {
    console.log('🎯 Testing Demo Join Group API...\n');
    console.log(`📋 Test Configuration:`);
    console.log(`- User ID: ${testUserId}`);
    console.log(`- Group ID: ${testGroupId}\n`);
    
    try {
        const response = await axios.post(`${BASE_URL}/groups/demo/join`, {
            userId: testUserId,
            groupId: testGroupId
        });
        
        console.log('✅ Demo Join Group Response:');
        console.log('Status:', response.status);
        console.log('Data:', JSON.stringify(response.data, null, 2));
        
        if (response.data.success) {
            console.log('\n🎉 User successfully joined the group!');
            console.log(`📊 Group: ${response.data.data.group.groupName}`);
            console.log(`📊 Group Type: ${response.data.data.group.groupType}`);
            console.log(`📊 Total Members: ${response.data.data.membership.totalMembers}`);
            console.log(`📊 User Role: ${response.data.data.user.role}`);
            console.log(`📊 User Join Date: ${response.data.data.user.joinDate}`);
            
            if (response.data.data.alreadyMember) {
                console.log('ℹ️ User was already a member of this group');
            }
        }
        
    } catch (error) {
        console.error('❌ Demo Join Group Error:');
        if (error.response) {
            console.error('Status:', error.response.status);
            console.error('Data:', JSON.stringify(error.response.data, null, 2));
        } else {
            console.error('Error:', error.message);
        }
    }
}

async function testInvalidScenarios() {
    console.log('\n🎯 Testing Invalid Scenarios...\n');
    
    // Test with missing userId
    console.log('1. Testing with missing userId:');
    try {
        await axios.post(`${BASE_URL}/groups/demo/join`, {
            groupId: testGroupId
        });
    } catch (error) {
        if (error.response && error.response.status === 400) {
            console.log('✅ Correctly returned 400 for missing userId');
        }
    }
    
    // Test with missing groupId
    console.log('\n2. Testing with missing groupId:');
    try {
        await axios.post(`${BASE_URL}/groups/demo/join`, {
            userId: testUserId
        });
    } catch (error) {
        if (error.response && error.response.status === 400) {
            console.log('✅ Correctly returned 400 for missing groupId');
        }
    }
    
    // Test with invalid userId
    console.log('\n3. Testing with invalid userId:');
    try {
        await axios.post(`${BASE_URL}/groups/demo/join`, {
            userId: '000000000000000000000000',
            groupId: testGroupId
        });
    } catch (error) {
        if (error.response && error.response.status === 404) {
            console.log('✅ Correctly returned 404 for invalid userId');
        }
    }
    
    // Test with invalid groupId
    console.log('\n4. Testing with invalid groupId:');
    try {
        await axios.post(`${BASE_URL}/groups/demo/join`, {
            userId: testUserId,
            groupId: '000000000000000000000000'
        });
    } catch (error) {
        if (error.response && error.response.status === 404) {
            console.log('✅ Correctly returned 404 for invalid groupId');
        }
    }
}

async function runAllTests() {
    console.log('🚀 Starting Demo Join Group API Tests...\n');
    
    // Test the main functionality
    await testDemoJoinGroup();
    
    // Test the same request again (should show already member)
    console.log('\n🔄 Testing same request again (should show already member)...\n');
    await testDemoJoinGroup();
    
    // Test invalid scenarios
    await testInvalidScenarios();
    
    console.log('\n🎯 All demo tests completed!');
}

// Run tests
runAllTests().catch(console.error);
