const express = require('express');
const router = express.Router();
const {
    createOrUpdateSchoolDetails,
    getSchoolDetails,
    getSchoolDetailsById,
    updateSchoolDetails,
    deleteSchoolDetails,
    getSchoolCompletion,
    getSchoolsByClass,
    getAllSchoolDetails
} = require('../controllers/schoolDetailsController');

const { authenticateToken } = require('../middleware/auth');
const { requestSizeLimiter } = require('../middleware/security');
const { 
    validateSchoolDetails, 
    validateSchoolDetailsUpdate 
} = require('../middleware/validation');

// Apply authentication to all routes
router.use(authenticateToken);

// Apply request size limiting to all routes
router.use(requestSizeLimiter);

// Create or update school details
router.post('/', 
    validateSchoolDetails,
    createOrUpdateSchoolDetails
);

// Get school details for current user
router.get('/', getSchoolDetails);

// Get school details by ID
router.get('/:id', getSchoolDetailsById);

// Update school details
router.put('/', 
    validateSchoolDetailsUpdate,
    updateSchoolDetails
);

// Delete school details
router.delete('/', deleteSchoolDetails);

// Get school completion status
router.get('/completion/status', getSchoolCompletion);

// Get schools by pincode and class
router.get('/schools/search', getSchoolsByClass);

// Get all school details (Admin)
router.get('/admin/all', getAllSchoolDetails);

module.exports = router;
