const express = require('express');
const router = express.Router();
const {
    createOrUpdatePersonalDetails,
    getPersonalDetails,
    getPersonalDetailsById,
    updatePersonalDetails,
    updatePersonalDetailsByUserId,
    deletePersonalDetails,
    getProfileCompletion,
    getAllPersonalDetails
} = require('../controllers/personalDetailsController');

const { authenticateToken } = require('../middleware/auth');
const { requestSizeLimiter } = require('../middleware/security');
const { validatePersonalDetails, validatePersonalDetailsUpdate } = require('../middleware/validation');

// All routes require authentication
router.use(authenticateToken);

// Personal details CRUD routes
router.post('/',
    requestSizeLimiter,
    validatePersonalDetails,
    createOrUpdatePersonalDetails
);

router.get('/',
    getPersonalDetails
);

router.get('/completion',
    getProfileCompletion
);

router.get('/:userId',
    getPersonalDetailsById
);

router.put('/',
    requestSizeLimiter,
    validatePersonalDetailsUpdate,
    updatePersonalDetails
);

// Update personal details by userId (simpler approach)
router.put('/:userId',
    requestSizeLimiter,
    validatePersonalDetailsUpdate,
    updatePersonalDetailsByUserId
);

router.delete('/',
    deletePersonalDetails
);

// Admin/testing routes
router.get('/admin/all',
    getAllPersonalDetails
);

module.exports = router;
