const express = require('express');
const router = express.Router();
const {
    getMentors,
    getMentorDetails,
    getMentorExpertise,
    bookMentorConsultation,
    createMentor,
    updateMentor
} = require('../controllers/mentorController');
const { authenticateAdmin } = require('../middleware/adminAuth');

// Public routes
router.get('/', getMentors);
router.get('/expertise', getMentorExpertise);
router.get('/:mentorId', getMentorDetails);
router.post('/:mentorId/book', bookMentorConsultation);

// Admin routes
router.post('/', authenticateAdmin, createMentor);
router.put('/:mentorId', authenticateAdmin, updateMentor);

module.exports = router;