const express = require('express');
const router = express.Router();
const {
    createOrUpdateBusinessDetails,
    getBusinessDetails,
    getBusinessDetailsById,
    updateBusinessDetails,
    deleteBusinessDetails,
    getBusinessCompletion,
    getAllBusinessDetails,
    searchBusinessesByLocation,
    searchBusinessesByIndustry
} = require('../controllers/businessController');

const { authenticateToken } = require('../middleware/auth');
const { requestSizeLimiter } = require('../middleware/security');
const { 
    validateBusinessDetails
} = require('../middleware/validation');

// Apply authentication to all routes
router.use(authenticateToken);

// Apply request size limiting to all routes
router.use(requestSizeLimiter);

// Create or update business details
router.post('/', 
    validateBusinessDetails,
    createOrUpdateBusinessDetails
);

// Get business details for current user
router.get('/', getBusinessDetails);

// Get business details by ID
router.get('/:id', getBusinessDetailsById);

// Update business details
router.put('/', updateBusinessDetails);

// Delete business details
router.delete('/', deleteBusinessDetails);

// Get business completion status
router.get('/completion/status', getBusinessCompletion);

// Search routes (public - for business discovery)
router.get('/search/location', searchBusinessesByLocation);
router.get('/search/industry', searchBusinessesByIndustry);

// Admin routes
router.get('/admin/all', getAllBusinessDetails);

module.exports = router;
