const express = require('express');
const router = express.Router();
const { login, getProfile } = require('../controllers/authController');
const { validateLogin } = require('../middleware/validation');
// const { validatePasswordStrength } = require('../middleware/security'); // Removed for testing
const { authenticateToken, requireOwnership } = require('../middleware/auth');

// Auth routes with security middlewares
router.post('/login', 
    login
);

router.get('/profile/:userId', 
    authenticateToken,
    requireOwnership('userId'),
    getProfile
);

module.exports = router;