const mongoose = require('mongoose');

const PortfolioAnalysisSchema = new mongoose.Schema({
  userId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true
  },
  resumeScore: {
    type: Number,
    min: 0,
    max: 10
  },
  skillGaps: [{
    skill: String,
    importance: {
      type: String,
      enum: ['high', 'medium', 'low']
    },
    learningPath: String,
    resources: [String]
  }],
  recommendations: [{
    type: {
      type: String,
      enum: ['skill', 'certification', 'project', 'experience']
    },
    title: String,
    description: String,
    priority: {
      type: String,
      enum: ['high', 'medium', 'low']
    }
  }],
  strengths: [String],
  weaknesses: [String],
  careerAlignment: {
    score: Number,
    suggestions: [String]
  },
  lastAnalyzed: {
    type: Date,
    default: Date.now
  }
}, {
  timestamps: true
});

module.exports = mongoose.model('PortfolioAnalysis', PortfolioAnalysisSchema);
