const mongoose = require('mongoose');

const portfolioSchema = new mongoose.Schema({
    userId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User',
        required: true
    },
    personalInfo: {
        fullName: String,
        email: String,
        phone: String,
        location: String,
        profilePicture: String,
        summary: String
    },
    education: [{
        degree: String,
        institution: String,
        year: Number,
        percentage: Number,
        achievements: [String]
    }],
    skills: [{
        name: String,
        level: {
            type: String,
            enum: ['beginner', 'intermediate', 'advanced', 'expert']
        },
        category: String
    }],
    certifications: [{
        name: String,
        provider: String,
        date: Date,
        certificateUrl: String
    }],
    projects: [{
        title: String,
        description: String,
        technologies: [String],
        githubUrl: String,
        liveUrl: String,
        imageUrl: String
    }],
    workExperience: [{
        company: String,
        position: String,
        duration: String,
        description: String,
        achievements: [String]
    }],
    achievements: [{
        title: String,
        description: String,
        date: Date,
        certificateUrl: String
    }],
    documents: [{
        name: String,
        type: String,
        url: String,
        uploadedAt: {
            type: Date,
            default: Date.now
        }
    }],
    isPublic: {
        type: Boolean,
        default: true
    },
    shareableLink: String,
    lastUpdated: {
        type: Date,
        default: Date.now
    }
}, {
    timestamps: true
});

module.exports = mongoose.model('Portfolio', portfolioSchema);
