const mongoose = require('mongoose');

const MentorSchema = new mongoose.Schema({
  name: {
    type: String,
    required: true
  },
  email: {
    type: String,
    required: true,
    unique: true
  },
  profession: {
    type: String,
    required: true
  },
  company: String,
  experience: Number,
  expertise: [String],
  education: [{
    degree: String,
    institution: String,
    year: Number
  }],
  achievements: [String],
  bio: String,
  rating: {
    average: Number,
    count: Number
  },
  consultationFee: {
    amount: Number,
    currency: {
      type: String,
      default: 'INR'
    }
  },
  availability: {
    days: [String],
    timeSlots: [String]
  },
  isVerified: {
    type: Boolean,
    default: false
  },
  isActive: {
    type: Boolean,
    default: true
  }
}, {
  timestamps: true
});

module.exports = mongoose.model('Mentor', MentorSchema);