const mongoose = require('mongoose');

const IndustryAnalysisSchema = new mongoose.Schema({
  industry: {
    type: String,
    required: true
  },
  description: String,
  skillsRequired: [String],
  topColleges: [String],
  exams: [String],
  salaryTrends: {
    entry: {
      min: Number,
      max: Number
    },
    mid: {
      min: Number,
      max: Number
    },
    senior: {
      min: Number,
      max: Number
    }
  },
  futureOutlook: {
    demand: {
      type: String,
      enum: ['high', 'medium', 'low']
    },
    growth: {
      type: String,
      enum: ['high', 'medium', 'low']
    },
    aiImpact: {
      type: String,
      enum: ['high', 'medium', 'low']
    },
    emergingFields: [String]
  },
  industrySwitching: [{
    fromIndustry: String,
    toIndustry: String,
    transitionPath: String,
    skillsToLearn: [String],
    timeRequired: String,
    successRate: Number
  }],
  jobRoles: [{
    title: String,
    description: String,
    salaryRange: {
      min: Number,
      max: Number
    },
    requirements: [String]
  }],
  isActive: {
    type: Boolean,
    default: true
  }
}, {
  timestamps: true
});

module.exports = mongoose.model('IndustryAnalysis', IndustryAnalysisSchema);
