const mongoose = require('mongoose');

const certificationSchema = new mongoose.Schema({
    name: {
        type: String,
        required: true,
        trim: true
    },
    provider: {
        type: String,
        required: true
    },
    category: {
        type: String,
        required: true,
        enum: ['technology', 'finance', 'healthcare', 'management', 'design', 'marketing', 'data_science', 'cloud_computing', 'cybersecurity', 'others']
    },
    level: {
        type: String,
        required: true,
        enum: ['beginner', 'intermediate', 'advanced', 'expert']
    },
    duration: {
        type: String,
        required: true
    },
    cost: {
        amount: Number,
        currency: {
            type: String,
            default: 'INR'
        }
    },
    prerequisites: [String],
    syllabus: [String],
    examFormat: {
        type: String,
        required: true
    },
    validity: {
        type: String,
        required: true
    },
    salaryIncrease: {
        percentage: Number,
        description: String
    },
    jobOpportunities: [String],
    difficulty: {
        type: String,
        enum: ['easy', 'medium', 'hard'],
        default: 'medium'
    },
    demand: {
        type: String,
        enum: ['low', 'medium', 'high'],
        default: 'medium'
    },
    website: String,
    isActive: {
        type: Boolean,
        default: true
    }
}, {
    timestamps: true
});

module.exports = mongoose.model('Certification', certificationSchema);
