const mongoose = require('mongoose');

const careerPathSchema = new mongoose.Schema({
    name: {
        type: String,
        required: true,
        trim: true
    },
    stage: {
        type: String,
        required: true,
        enum: ['class_6_10', 'class_11_12', 'graduation', 'working_professional']
    },
    description: {
        type: String,
        required: true
    },
    prerequisites: [String],
    duration: {
        type: String,
        required: true
    },
    salaryRange: {
        min: Number,
        max: Number,
        currency: {
            type: String,
            default: 'INR'
        }
    },
    jobRoles: [String],
    skillsRequired: [String],
    exams: [String],
    topColleges: [String],
    pros: [String],
    cons: [String],
    famousPersonalities: [{
        name: String,
        profession: String,
        achievement: String
    }],
    futureScope: String,
    difficulty: {
        type: String,
        enum: ['easy', 'medium', 'hard'],
        default: 'medium'
    },
    demand: {
        type: String,
        enum: ['low', 'medium', 'high'],
        default: 'medium'
    },
    isActive: {
        type: Boolean,
        default: true
    }
}, {
    timestamps: true
});

module.exports = mongoose.model('CareerPath', careerPathSchema);
