# Cuts Thumbnail Generation

## Overview
The cuts (video) system now supports automatic thumbnail generation using FFmpeg to extract frames from uploaded videos. If FFmpeg is not available, the system falls back to creating informative placeholder thumbnails.

## Features

### ✅ **Automatic Video Frame Extraction**
- Extracts thumbnail at 10% of video duration
- Standard size: 320x240 pixels
- Supports all major video formats (MP4, AVI, MOV, WMV, etc.)
- High-quality JPEG thumbnails

### ✅ **Fallback Thumbnail Generation**
- Creates informative placeholder when FFmpeg is unavailable
- Dark theme with clear text indicating thumbnail status
- Consistent 320x240 pixel size
- Professional appearance

### ✅ **Organized File Structure**
```
uploads/
└── cuts/
    ├── video_files/
    │   ├── cut_video_1234567890_abc123.mp4
    │   └── cut_video_1234567891_def456.avi
    └── thumbnails/
        ├── cut_video_1234567890_abc123_thumb.jpg
        └── cut_video_1234567891_def456_thumb.jpg
```

## Installation Requirements

### **For Full Video Frame Extraction (Recommended)**

1. **Install FFmpeg:**
   - **Windows:** Download from [https://ffmpeg.org/download.html](https://ffmpeg.org/download.html)
   - **macOS:** `brew install ffmpeg`
   - **Linux:** `sudo apt install ffmpeg` or `sudo yum install ffmpeg`

2. **Verify Installation:**
   ```bash
   ffmpeg -version
   ```

3. **Add to PATH (Windows):**
   - Extract FFmpeg to a folder (e.g., `C:\ffmpeg`)
   - Add `C:\ffmpeg\bin` to your system PATH
   - Restart your terminal/command prompt

### **Current Setup (Fallback Mode)**
- Works without FFmpeg installation
- Creates placeholder thumbnails with informative text
- Fully functional for testing and development

## API Endpoints

### **Create Cut with Thumbnail**
```bash
POST /api/cuts
Content-Type: multipart/form-data
Authorization: Bearer <token>

Fields:
- video: [video file]
- title: "Cut Title"
- description: "Cut Description"
- visibility: "public" | "private"
- interests: ["technology", "programming"]
- tags: ["demo", "tutorial"]
```

### **Response Example**
```json
{
  "success": true,
  "message": "Cut created successfully",
  "data": {
    "_id": "cut_id",
    "title": "My Video Cut",
    "video": {
      "filename": "cut_video_1234567890_abc123.mp4",
      "url": "/uploads/cuts/cut_video_1234567890_abc123.mp4",
      "size": 15728640,
      "mimeType": "video/mp4"
    },
    "thumbnail": {
      "filename": "cut_video_1234567890_abc123_thumb.jpg",
      "url": "/uploads/cuts/thumbnails/cut_video_1234567890_abc123_thumb.jpg",
      "size": 245760,
      "mimeType": "image/jpeg"
    },
    "createdAt": "2025-01-15T10:30:00.000Z"
  }
}
```

### **Get User Cuts with Thumbnails**
```bash
GET /api/cuts/user/:userId?page=1&limit=10
```

### **Serve Thumbnails**
```bash
GET /uploads/cuts/thumbnails/:filename
```

## Debugging

### **Console Logs**
The system provides detailed logging for thumbnail generation:

```
🎬 [THUMBNAIL DEBUG] Generating thumbnail for: uploads/cuts/video.mp4
✅ [THUMBNAIL DEBUG] Thumbnail generated successfully: uploads/cuts/thumbnails/video_thumb.jpg
```

**FFmpeg Error (Fallback Mode):**
```
❌ [THUMBNAIL ERROR] FFmpeg error: Error: Cannot find ffmpeg
🎬 [THUMBNAIL DEBUG] FFmpeg not available, creating fallback thumbnail...
🎬 [THUMBNAIL DEBUG] To enable video frame extraction, install FFmpeg: https://ffmpeg.org/download.html
✅ [THUMBNAIL DEBUG] Fallback thumbnail created: uploads/cuts/thumbnails/video_thumb.jpg
```

### **File System Debugging**
```bash
# Check if thumbnails directory exists
ls -la uploads/cuts/thumbnails/

# Check thumbnail file
file uploads/cuts/thumbnails/video_thumb.jpg
```

## Performance Considerations

### **Thumbnail Generation**
- **With FFmpeg:** ~1-3 seconds per video
- **Fallback Mode:** ~100-200ms per thumbnail
- **File Size:** Typically 20-50KB per thumbnail

### **Storage**
- Thumbnails stored separately from videos
- Automatic cleanup when cuts are deleted
- Efficient JPEG compression

### **Caching**
- Thumbnails cached for 24 hours
- Browser caching enabled
- CDN-ready URL structure

## Troubleshooting

### **Common Issues**

1. **Blank/Gray Thumbnails:**
   - FFmpeg not installed or not in PATH
   - Video file corrupted or unsupported format
   - Check console logs for specific errors

2. **Thumbnails Not Generated:**
   - Verify video file upload succeeded
   - Check file permissions on uploads directory
   - Ensure sufficient disk space

3. **Thumbnails Not Loading:**
   - Verify server route: `/uploads/cuts/thumbnails/:filename`
   - Check file exists in correct directory
   - Verify MIME type headers

### **Testing**
```bash
# Test thumbnail generation
curl -X POST "http://localhost:5500/api/cuts" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -F "video=@test_video.mp4" \
  -F "title=Test Cut"

# Check thumbnail URL in response
curl "http://localhost:5500/uploads/cuts/thumbnails/THUMBNAIL_FILENAME"
```

## Future Enhancements

- [ ] Multiple thumbnail options (start, middle, end)
- [ ] Custom thumbnail upload
- [ ] Animated GIF thumbnails
- [ ] AI-powered thumbnail selection
- [ ] Thumbnail optimization for different screen sizes

---

**Note:** For production use, ensure FFmpeg is properly installed and configured for optimal video processing performance.
