# Career Guidance API Documentation

## Overview
This API provides comprehensive career guidance services for students from Class 6 to working professionals. It includes features like career goal setting, exam information, college finder, quiz system, study groups, portfolio management, and more.

## Base URL
```
http://localhost:5000/api
```

## Authentication
Most endpoints require authentication. Include the JWT token in the Authorization header:
```
Authorization: Bearer <your-jwt-token>
```

---

## 1. Career Goals API

### Set Career Goal
**POST** `/career/goal`

Set or update user's career goal.

**Request Body:**
```json
{
  "selectedPath": "engineering",
  "currentStage": "class_11_12",
  "specificGoal": "B.Tech Computer Science from IIT",
  "targetYear": 2025
}
```

**Response:**
```json
{
  "success": true,
  "message": "Career goal set successfully",
  "data": {
    "_id": "...",
    "userId": "...",
    "selectedPath": "engineering",
    "currentStage": "class_11_12",
    "specificGoal": "B.Tech Computer Science from IIT",
    "targetYear": 2025,
    "progressPercentage": 0
  }
}
```

### Get Career Goal
**GET** `/career/goal`

Get user's current career goal.

### Update Career Progress
**PUT** `/career/goal/progress`

Update progress of career goal.

**Request Body:**
```json
{
  "progressPercentage": 25,
  "isCompleted": false
}
```

### Get Career Suggestions
**GET** `/career/suggestions`

Get personalized career suggestions based on user's goal.

### Get Career Progress
**GET** `/career/progress`

Get detailed career progress tracking.

---

## 2. Career Paths API

### Get Career Paths
**GET** `/career-paths?stage=class_11_12`

Get available career paths for a specific stage.

**Response:**
```json
{
  "success": true,
  "data": [
    {
      "_id": "...",
      "name": "Engineering",
      "stage": "class_11_12",
      "description": "Engineering is a broad field...",
      "salaryRange": { "min": 300000, "max": 1500000 },
      "jobRoles": ["Software Engineer", "Mechanical Engineer"],
      "skillsRequired": ["Problem Solving", "Analytical Thinking"],
      "exams": ["JEE Main", "JEE Advanced"],
      "topColleges": ["IITs", "NITs"],
      "pros": ["High salary potential", "Job security"],
      "cons": ["Competitive entrance exams"],
      "famousPersonalities": [
        {
          "name": "Sundar Pichai",
          "profession": "CEO Google",
          "achievement": "Led Google to new heights"
        }
      ]
    }
  ]
}
```

### Get Career Path Details
**GET** `/career-paths/:pathId`

Get detailed information about a specific career path.

---

## 3. Exams API

### Get Exams by Stage
**GET** `/exams/stage/:stage?category=entrance&page=1&limit=10`

Get exams for a specific educational stage.

**Response:**
```json
{
  "success": true,
  "data": {
    "exams": [
      {
        "_id": "...",
        "name": "JEE Main",
        "fullForm": "Joint Entrance Examination Main",
        "stage": "class_11_12",
        "category": "entrance",
        "conductingBody": "National Testing Agency",
        "eligibility": {
          "minAge": 17,
          "maxAge": 25,
          "education": "Class 12 with Physics, Chemistry, Mathematics",
          "percentage": 75
        },
        "examPattern": {
          "mode": "online",
          "duration": 180,
          "totalMarks": 300,
          "sections": [
            {
              "name": "Physics",
              "marks": 100,
              "questions": 25,
              "duration": 60
            }
          ]
        },
        "syllabus": ["Physics", "Chemistry", "Mathematics"],
        "applicationFee": { "general": 1000, "reserved": 500 },
        "importantDates": {
          "applicationStart": "2024-01-01T00:00:00.000Z",
          "applicationEnd": "2024-01-31T00:00:00.000Z",
          "examDate": "2024-04-01T00:00:00.000Z"
        },
        "cutoffs": { "general": 95, "obc": 85 },
        "topColleges": ["IIT Delhi", "IIT Bombay"],
        "studyTips": ["Strong foundation in PCM", "Regular practice"],
        "officialWebsite": "https://jeemain.nta.nic.in"
      }
    ],
    "pagination": {
      "currentPage": 1,
      "totalPages": 2,
      "totalExams": 15,
      "hasNext": true,
      "hasPrev": false
    }
  }
}
```

### Search Exams
**GET** `/exams/search?query=JEE&stage=class_11_12`

Search exams by name, conducting body, etc.

### Get Upcoming Exams
**GET** `/exams/upcoming?stage=class_11_12`

Get exams with upcoming application deadlines.

### Get Exam Details
**GET** `/exams/:examId`

Get detailed information about a specific exam.

### Get Exam Categories
**GET** `/exams/categories`

Get all available exam categories and stages.

---

## 4. Quiz API

### Get Quiz Questions
**GET** `/quiz/questions?category=gk&difficulty=medium&stage=class_11_12&limit=10`

Get quiz questions for practice.

**Response:**
```json
{
  "success": true,
  "data": {
    "questions": [
      {
        "_id": "...",
        "question": "Who is the current Prime Minister of India?",
        "options": ["Narendra Modi", "Rahul Gandhi", "Arvind Kejriwal", "Mamata Banerjee"],
        "category": "current_affairs",
        "difficulty": "easy",
        "stage": "class_6_10",
        "tags": ["politics", "india"]
      }
    ],
    "totalQuestions": 10
  }
}
```

### Submit Quiz Answers
**POST** `/quiz/submit`

Submit quiz answers and get results.

**Request Body:**
```json
{
  "answers": [
    {
      "quizId": "...",
      "userAnswer": 0,
      "timeSpent": 30
    },
    {
      "quizId": "...",
      "userAnswer": 2,
      "timeSpent": 45
    }
  ]
}
```

**Response:**
```json
{
  "success": true,
  "data": {
    "score": 80,
    "correctAnswers": 8,
    "totalQuestions": 10,
    "attemptDetails": [
      {
        "quizId": "...",
        "question": "Who is the current Prime Minister of India?",
        "userAnswer": 0,
        "correctAnswer": 0,
        "isCorrect": true,
        "explanation": "Narendra Modi is the current Prime Minister..."
      }
    ],
    "message": "Good job!"
  }
}
```

### Get Quiz Leaderboard
**GET** `/quiz/leaderboard?category=gk&timeframe=month`

Get quiz leaderboard for different time periods.

### Get User Quiz Stats
**GET** `/quiz/stats`

Get user's quiz statistics and performance.

### Get Quiz Categories
**GET** `/quiz/categories`

Get available quiz categories and difficulty levels.

---

## 5. Colleges API

### Get Colleges by Course
**GET** `/colleges/course?courseType=btech&state=Delhi&category=iit&page=1&limit=10`

Get colleges offering specific courses.

**Response:**
```json
{
  "success": true,
  "data": {
    "colleges": [
      {
        "_id": "...",
        "name": "Indian Institute of Technology Delhi",
        "type": "government",
        "category": "iit",
        "location": {
          "state": "Delhi",
          "city": "New Delhi",
          "address": "Hauz Khas, New Delhi"
        },
        "courses": [
          {
            "name": "B.Tech Computer Science",
            "duration": 4,
            "type": "btech",
            "specializations": ["AI/ML", "Data Science"]
          }
        ],
        "fees": {
          "tuitionFee": 100000,
          "hostelFee": 60000,
          "totalFirstYear": 180000
        },
        "placement": {
          "averagePackage": 1500000,
          "highestPackage": 5000000,
          "placementPercentage": 95,
          "topRecruiters": ["Google", "Microsoft", "Amazon"]
        },
        "ranking": { "nirf": 2, "times": 5 },
        "website": "https://www.iitd.ac.in"
      }
    ],
    "pagination": {
      "currentPage": 1,
      "totalPages": 3,
      "totalColleges": 25,
      "hasNext": true,
      "hasPrev": false
    }
  }
}
```

### Check College Eligibility
**GET** `/colleges/eligibility?rank=500&category=general&exam=JEE%20Main&course=B.Tech%20Computer%20Science`

Check which colleges user is eligible for based on rank.

### Search Colleges
**GET** `/colleges/search?query=IIT&state=Maharashtra&category=iit`

Search colleges by name, location, etc.

### Get College Details
**GET** `/colleges/:collegeId`

Get detailed information about a specific college.

### Get Top Colleges
**GET** `/colleges/top?category=iit&limit=10`

Get top-ranked colleges by category.

### Get College Statistics
**GET** `/colleges/stats`

Get overall statistics about colleges in the database.

---

## 6. Study Groups API

### Create Study Group
**POST** `/study-groups`

Create a new study group.

**Request Body:**
```json
{
  "name": "JEE Main 2024 Preparation",
  "description": "Study group for JEE Main aspirants",
  "exam": "JEE Main",
  "stage": "class_11_12",
  "isPublic": true,
  "maxMembers": 50
}
```

### Get Study Groups
**GET** `/study-groups?exam=JEE%20Main&stage=class_11_12&page=1&limit=10`

Get available study groups.

### Join Study Group
**POST** `/study-groups/:groupId/join`

Join a study group.

### Leave Study Group
**DELETE** `/study-groups/:groupId/leave`

Leave a study group.

### Get Study Group Details
**GET** `/study-groups/:groupId`

Get detailed information about a study group.

### Create Group Post
**POST** `/study-groups/:groupId/posts`

Create a post in study group.

**Request Body:**
```json
{
  "content": "Can someone help me with this physics problem?",
  "type": "question"
}
```

### Get Study Group Posts
**GET** `/study-groups/:groupId/posts?page=1&limit=10`

Get posts from a study group.

### Like/Unlike Post
**POST** `/study-groups/posts/:postId/like`

Like or unlike a post.

### Add Comment
**POST** `/study-groups/posts/:postId/comment`

Add comment to a post.

**Request Body:**
```json
{
  "content": "Here's the solution to your problem..."
}
```

---

## 7. Portfolio API

### Create/Update Portfolio
**POST** `/portfolio`

Create or update user's portfolio.

**Request Body:**
```json
{
  "personalInfo": {
    "fullName": "John Doe",
    "email": "john@example.com",
    "phone": "+91-9876543210",
    "location": "Delhi, India",
    "summary": "Computer Science student with passion for AI/ML"
  },
  "education": [
    {
      "degree": "B.Tech Computer Science",
      "institution": "IIT Delhi",
      "year": 2023,
      "percentage": 85,
      "achievements": ["Dean's List", "Best Project Award"]
    }
  ],
  "skills": [
    {
      "name": "Python",
      "level": "advanced",
      "category": "Programming"
    }
  ],
  "projects": [
    {
      "title": "AI Chatbot",
      "description": "Built an intelligent chatbot using NLP",
      "technologies": ["Python", "TensorFlow", "Flask"],
      "githubUrl": "https://github.com/user/chatbot"
    }
  ],
  "isPublic": true
}
```

### Get User Portfolio
**GET** `/portfolio`

Get user's portfolio.

### Get Public Portfolio
**GET** `/portfolio/public/:userId`

Get public portfolio by user ID.

### Add Education
**POST** `/portfolio/education`

Add education entry to portfolio.

### Add Skill
**POST** `/portfolio/skills`

Add skill to portfolio.

### Add Project
**POST** `/portfolio/projects`

Add project to portfolio.

### Add Work Experience
**POST** `/portfolio/work-experience`

Add work experience to portfolio.

### Upload Document
**POST** `/portfolio/documents`

Upload document to portfolio (multipart/form-data).

### Toggle Portfolio Visibility
**PUT** `/portfolio/visibility`

Toggle portfolio between public and private.

### Delete Portfolio Item
**DELETE** `/portfolio/:section/:itemId`

Delete specific item from portfolio (education, skills, projects, etc.).

---

## 8. Certifications API

### Get Certifications
**GET** `/certifications?category=technology&level=advanced&page=1&limit=10`

Get certifications by category and level.

**Response:**
```json
{
  "success": true,
  "data": {
    "certifications": [
      {
        "_id": "...",
        "name": "AWS Certified Solutions Architect",
        "provider": "Amazon Web Services",
        "category": "cloud_computing",
        "level": "intermediate",
        "duration": "3-6 months",
        "cost": { "amount": 15000, "currency": "INR" },
        "prerequisites": ["Basic understanding of cloud computing"],
        "syllabus": ["AWS Core Services", "Security", "Architecture Design"],
        "examFormat": "Multiple choice questions",
        "validity": "3 years",
        "salaryIncrease": { "percentage": 25 },
        "jobOpportunities": ["Cloud Architect", "DevOps Engineer"],
        "difficulty": "hard",
        "demand": "high",
        "website": "https://aws.amazon.com/certification/"
      }
    ],
    "pagination": {
      "currentPage": 1,
      "totalPages": 2,
      "totalCertifications": 15
    }
  }
}
```

### Get Certification Details
**GET** `/certifications/:certId`

Get detailed information about a specific certification.

### Get Certification Categories
**GET** `/certifications/categories`

Get available certification categories and levels.

---

## 9. Mentors API

### Get Mentors
**GET** `/mentors?expertise=technology&page=1&limit=10`

Get available mentors.

**Response:**
```json
{
  "success": true,
  "data": {
    "mentors": [
      {
        "_id": "...",
        "name": "Dr. Rajesh Kumar",
        "profession": "Software Engineer",
        "company": "Google",
        "experience": 10,
        "expertise": ["Machine Learning", "Cloud Computing"],
        "education": [
          {
            "degree": "PhD Computer Science",
            "institution": "IIT Delhi",
            "year": 2015
          }
        ],
        "achievements": ["Published 20 research papers", "Led 5 major projects"],
        "bio": "Experienced software engineer with expertise in ML and cloud technologies",
        "rating": { "average": 4.8, "count": 25 },
        "consultationFee": { "amount": 2000, "currency": "INR" },
        "isVerified": true
      }
    ],
    "pagination": {
      "currentPage": 1,
      "totalPages": 3,
      "totalMentors": 25
    }
  }
}
```

### Get Mentor Details
**GET** `/mentors/:mentorId`

Get detailed information about a specific mentor.

### Get Mentor Expertise Areas
**GET** `/mentors/expertise/list`

Get list of available expertise areas.

---

## Error Responses

All endpoints may return the following error responses:

### 400 Bad Request
```json
{
  "success": false,
  "message": "Invalid request data",
  "error": "Validation error details"
}
```

### 401 Unauthorized
```json
{
  "success": false,
  "message": "Authentication required"
}
```

### 404 Not Found
```json
{
  "success": false,
  "message": "Resource not found"
}
```

### 500 Internal Server Error
```json
{
  "success": false,
  "message": "Something went wrong!"
}
```

---

## Data Seeding

To populate the database with sample data, run:

```bash
# Seed basic career data
npm run seed:career

# Seed additional career data
npm run seed:more-career
```

---

## Rate Limiting

- Quiz submissions: 10 per hour per user
- Study group posts: 20 per hour per user
- Portfolio updates: 5 per hour per user

---

## File Uploads

- Maximum file size: 10MB
- Allowed formats: Images (JPEG, PNG, GIF), Documents (PDF, DOC, DOCX, TXT)
- Files are stored in `/uploads/portfolio/` directory

---

## Notes

1. All timestamps are in ISO 8601 format
2. Pagination is 1-based (page 1, 2, 3...)
3. All text searches are case-insensitive
4. JWT tokens expire in 24 hours
5. File uploads require multipart/form-data content type
