# Admin Authentication API

This document describes the admin authentication API endpoints for the Reconnectifly backend.

## Admin Credentials

- **Email**: `reconnectifly.rif@gmail.com`
- **Password**: `Reconnectifly.Rif2025`
- **Role**: `super_admin`

## API Endpoints

### Base URL
```
http://localhost:5000/api/admin
```

### 1. Admin Login
**POST** `/login`

Login with admin credentials.

**Request Body:**
```json
{
  "email": "reconnectifly.rif@gmail.com",
  "password": "Reconnectifly.Rif2025"
}
```

**Response:**
```json
{
  "success": true,
  "message": "Admin login successful",
  "data": {
    "admin": {
      "id": "admin_id",
      "name": "Reconnectifly Admin",
      "email": "reconnectifly.rif@gmail.com",
      "role": "super_admin",
      "lastLogin": "2025-01-15T10:30:00.000Z"
    },
    "token": "jwt_token_here"
  }
}
```

### 2. Get Admin Profile
**GET** `/profile`

Get the authenticated admin's profile.

**Headers:**
```
Authorization: Bearer <jwt_token>
```

**Response:**
```json
{
  "success": true,
  "data": {
    "id": "admin_id",
    "name": "Reconnectifly Admin",
    "email": "reconnectifly.rif@gmail.com",
    "role": "super_admin",
    "isActive": true,
    "lastLogin": "2025-01-15T10:30:00.000Z",
    "createdAt": "2025-01-15T10:00:00.000Z",
    "updatedAt": "2025-01-15T10:30:00.000Z"
  }
}
```

### 3. Update Admin Profile
**PUT** `/profile`

Update the authenticated admin's profile.

**Headers:**
```
Authorization: Bearer <jwt_token>
```

**Request Body:**
```json
{
  "name": "Updated Admin Name"
}
```

**Response:**
```json
{
  "success": true,
  "message": "Profile updated successfully",
  "data": {
    "id": "admin_id",
    "name": "Updated Admin Name",
    "email": "reconnectifly.rif@gmail.com",
    "role": "super_admin"
  }
}
```

### 4. Change Password
**PUT** `/change-password`

Change the authenticated admin's password.

**Headers:**
```
Authorization: Bearer <jwt_token>
```

**Request Body:**
```json
{
  "currentPassword": "Reconnectifly.Rif2025",
  "newPassword": "NewPassword123"
}
```

**Response:**
```json
{
  "success": true,
  "message": "Password changed successfully"
}
```

### 5. Admin Logout
**POST** `/logout`

Logout the authenticated admin.

**Headers:**
```
Authorization: Bearer <jwt_token>
```

**Response:**
```json
{
  "success": true,
  "message": "Logout successful"
}
```

### 6. Verify Token
**GET** `/verify`

Verify if the provided JWT token is valid.

**Headers:**
```
Authorization: Bearer <jwt_token>
```

**Response:**
```json
{
  "success": true,
  "message": "Admin token is valid",
  "data": {
    "admin": {
      "id": "admin_id",
      "name": "Reconnectifly Admin",
      "email": "reconnectifly.rif@gmail.com",
      "role": "super_admin"
    }
  }
}
```

## Security Features

### Rate Limiting
- Login attempts are rate-limited to prevent brute force attacks
- Uses the same rate limiter as regular user authentication

### Account Lockout
- Account is locked after 5 failed login attempts
- Lock duration: 2 hours
- Lock is automatically released after the time period

### JWT Token Security
- Tokens expire after 24 hours
- Tokens include admin type verification
- Tokens are validated on each protected request

### Password Security
- Passwords are hashed using SHA-256
- Password verification is done securely
- Password change requires current password verification

## Error Responses

### 400 Bad Request
```json
{
  "success": false,
  "message": "Email and password are required"
}
```

### 401 Unauthorized
```json
{
  "success": false,
  "message": "Invalid email or password"
}
```

### 403 Forbidden
```json
{
  "success": false,
  "message": "Invalid token type. Admin access required."
}
```

### 423 Locked
```json
{
  "success": false,
  "message": "Account is temporarily locked due to too many failed login attempts. Please try again later."
}
```

### 500 Internal Server Error
```json
{
  "success": false,
  "message": "Login failed",
  "error": "Error details"
}
```

## Setup Instructions

1. **Initialize the default admin:**
   ```bash
   npm run init:admin
   ```

2. **Test the API:**
   ```bash
   npm run test:admin
   ```

3. **Start the server:**
   ```bash
   npm run dev
   ```

## Frontend Integration

The admin panel frontend should:

1. Send login requests to `POST /api/admin/login`
2. Store the JWT token in localStorage or secure storage
3. Include the token in the `Authorization` header for protected requests
4. Handle token expiration and redirect to login when needed
5. Implement proper error handling for all API responses

## Database Schema

The Admin model includes:
- Email (unique, required)
- Password (hashed, required)
- Name (required)
- Role (enum: super_admin, admin, moderator)
- isActive (boolean, default: true)
- lastLogin (Date)
- loginAttempts (Number, default: 0)
- lockUntil (Date, for account lockout)
- timestamps (createdAt, updatedAt)
